/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.entity;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.core.ItemUtil;
import flash.npcmod.core.PermissionHelper;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.core.trades.TradeOffer;
import flash.npcmod.core.trades.TradeOffers;
import flash.npcmod.entity.goals.TalkWithPlayerGoal;
import flash.npcmod.init.EntityInit;
import flash.npcmod.item.NpcEditorItem;
import flash.npcmod.item.NpcSaveToolItem;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CRequestDialogue;
import flash.npcmod.network.packets.client.CRequestDialogueEditor;
import flash.npcmod.network.packets.client.CRequestTrades;
import flash.npcmod.network.packets.server.SCompleteQuest;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class NpcEntity
extends PathfinderMob {
    public static String TYPE_STRING = EntityType.m_20613_((EntityType)((EntityType)EntityInit.NPC_ENTITY.get())).toString();
    private static final EntityDataAccessor<String> TITLE = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<CompoundTag> RENDERER_TAG = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> CROUCHING = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DIALOGUE = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<BlockPos> ORIGIN = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDimensions SITTING_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)1.3f);
    private static final EntityDataAccessor<Boolean> SLIM = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TEXTCOLOR = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_TEXTURE_RESOURCE_LOCATION = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SCALE_X = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SCALE_Y = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SCALE_Z = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> COLLISION = SynchedEntityData.m_135353_(NpcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)Player.f_36088_).put((Object)Pose.SLEEPING, (Object)f_20910_).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)SITTING_DIMENSIONS).put((Object)Pose.CROUCHING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)1.5f)).put((Object)Pose.DYING, (Object)EntityDimensions.m_20398_((float)0.2f, (float)0.2f)).build();
    public static final int MAX_OFFERS = 12;
    private static final int MAX_TELEPORT_COUNTER = 300;
    @Nullable
    private Player talkingPlayer;
    private int teleportCounter = 0;
    @Nullable
    private TradeOffers tradeOffers;
    private LivingEntity renderedEntity;
    private CompoundTag prevRenderedEntityTag;
    private Component titleComponent = TextComponent.f_131282_;

    public NpcEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.m_21530_();
    }

    protected NpcEntity(Level world) {
        this((EntityType<? extends PathfinderMob>)((EntityType)EntityInit.NPC_ENTITY.get()), world);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("title", this.getTitle());
        compound.m_128359_("dialogue", this.getDialogue());
        compound.m_128379_("nameVisibility", this.m_20151_());
        compound.m_128379_("slim", this.isSlim());
        compound.m_128405_("textColor", this.getTextColor());
        compound.m_128359_("texture", this.getTexture());
        compound.m_128379_("is_texture_resource_loc", this.isTextureResourceLocation());
        compound.m_128365_("origin", (Tag)NbtUtils.m_129224_((BlockPos)this.getOrigin()));
        compound.m_128379_("sitting", this.isSitting());
        compound.m_128379_("crouching", this.m_6047_());
        compound.m_128365_("renderer", (Tag)this.getRenderedEntityTagWithId());
        compound.m_128350_("scaleX", this.getScaleX());
        compound.m_128350_("scaleY", this.getScaleY());
        compound.m_128350_("scaleZ", this.getScaleZ());
        compound.m_128379_("collision", this.hasCollision());
        TradeOffers tradeOffers = this.getOffers();
        if (!tradeOffers.isEmpty()) {
            compound.m_128365_("Offers", (Tag)tradeOffers.write());
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setCrouching(compound.m_128471_("crouching"));
        this.m_20340_(compound.m_128471_("nameVisibility"));
        this.setTitle(compound.m_128461_("title"));
        this.setDialogue(compound.m_128461_("dialogue"));
        this.setOrigin(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("origin")));
        this.setSitting(compound.m_128471_("sitting"));
        this.setSlim(compound.m_128471_("slim"));
        this.setTextColor(compound.m_128451_("textColor"));
        this.setTexture(compound.m_128461_("texture"));
        if (compound.m_128441_("is_texture_resource_loc")) {
            this.setIsTextureResourceLocation(compound.m_128471_("is_texture_resource_loc"));
        }
        this.setRenderedEntityFromTag((CompoundTag)compound.m_128423_("renderer"));
        this.setScale(compound.m_128457_("scaleX"), compound.m_128457_("scaleY"), compound.m_128457_("scaleZ"));
        this.setCollision(compound.m_128471_("collision"));
        if (compound.m_128425_("Offers", 10)) {
            this.tradeOffers = new TradeOffers(compound.m_128469_("Offers"));
        }
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", this.m_7755_().getString());
        jsonObject.addProperty("nameVisibility", Boolean.valueOf(this.m_20151_()));
        jsonObject.addProperty("dialogue", this.getDialogue());
        jsonObject.addProperty("title", this.getTitle());
        jsonObject.addProperty("texture", this.getTexture());
        jsonObject.addProperty("is_texture_resource_loc", Boolean.valueOf(this.isTextureResourceLocation()));
        jsonObject.addProperty("textColor", (Number)this.getTextColor());
        jsonObject.addProperty("slim", Boolean.valueOf(this.isSlim()));
        jsonObject.addProperty("pose", this.isSitting() ? "sitting" : (this.m_6047_() ? "crouching" : "standing"));
        jsonObject.addProperty("trades", this.getOffers().write().m_7916_());
        jsonObject.addProperty("renderer", this.getRenderedEntityTagWithId().m_7916_());
        JsonObject scale = new JsonObject();
        scale.addProperty("x", (Number)Float.valueOf(this.getScaleX()));
        scale.addProperty("y", (Number)Float.valueOf(this.getScaleY()));
        scale.addProperty("z", (Number)Float.valueOf(this.getScaleZ()));
        jsonObject.add("scale", (JsonElement)scale);
        jsonObject.addProperty("collision", Boolean.valueOf(this.hasCollision()));
        jsonObject.add("inventory", (JsonElement)this.inventoryToJson());
        return jsonObject;
    }

    public static NpcEntity fromJson(Level level, JsonObject jsonObject) {
        String pose;
        NpcEntity npcEntity = (NpcEntity)((EntityType)EntityInit.NPC_ENTITY.get()).m_20615_(level);
        assert (npcEntity != null);
        npcEntity.m_20340_(jsonObject.get("nameVisibility").getAsBoolean());
        npcEntity.setDialogue(jsonObject.get("dialogue").getAsString());
        npcEntity.m_6593_((Component)new TextComponent(jsonObject.get("name").getAsString()));
        if (jsonObject.has("title")) {
            npcEntity.setTitle(jsonObject.get("title").getAsString());
        }
        npcEntity.setSlim(jsonObject.get("slim").getAsBoolean());
        npcEntity.setTexture(jsonObject.get("texture").getAsString());
        if (jsonObject.has("is_texture_resource_loc")) {
            npcEntity.setIsTextureResourceLocation(jsonObject.get("is_texture_resource_loc").getAsBoolean());
        }
        npcEntity.setTextColor(jsonObject.get("textColor").getAsInt());
        switch (pose = jsonObject.get("pose").getAsString()) {
            case "sitting": {
                npcEntity.setSitting(true);
                break;
            }
            case "crouching": {
                npcEntity.setCrouching(true);
            }
        }
        if (jsonObject.has("scale")) {
            JsonObject scale = jsonObject.get("scale").getAsJsonObject();
            npcEntity.setScale(scale.get("x").getAsFloat(), scale.get("y").getAsFloat(), scale.get("z").getAsFloat());
        }
        if (jsonObject.has("collision")) {
            npcEntity.setCollision(jsonObject.get("collision").getAsBoolean());
        }
        npcEntity.tradeOffers = TradeOffers.read(jsonObject.get("trades").getAsString());
        try {
            npcEntity.setRenderedEntityFromTag(new TagParser(new StringReader(jsonObject.get("renderer").getAsString())).m_129373_());
        }
        catch (Exception scale) {
            // empty catch block
        }
        JsonObject inventory = jsonObject.getAsJsonObject("inventory");
        npcEntity.m_8061_(EquipmentSlot.MAINHAND, ItemUtil.stackFromString(inventory.get("mainHand").getAsString()));
        npcEntity.m_8061_(EquipmentSlot.OFFHAND, ItemUtil.stackFromString(inventory.get("offHand").getAsString()));
        npcEntity.m_8061_(EquipmentSlot.HEAD, ItemUtil.stackFromString(inventory.get("head").getAsString()));
        npcEntity.m_8061_(EquipmentSlot.CHEST, ItemUtil.stackFromString(inventory.get("chest").getAsString()));
        npcEntity.m_8061_(EquipmentSlot.LEGS, ItemUtil.stackFromString(inventory.get("legs").getAsString()));
        npcEntity.m_8061_(EquipmentSlot.FEET, ItemUtil.stackFromString(inventory.get("feet").getAsString()));
        return npcEntity;
    }

    protected boolean m_7341_(@NotNull Entity entity) {
        return false;
    }

    public boolean m_6573_(@NotNull Player player) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CROUCHING, (Object)false);
        this.f_19804_.m_135372_(DIALOGUE, (Object)"");
        this.f_19804_.m_135372_(ORIGIN, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(TEXTCOLOR, (Object)0xFFFFFF);
        this.f_19804_.m_135372_(TEXTURE, (Object)"");
        this.f_19804_.m_135372_(IS_TEXTURE_RESOURCE_LOCATION, (Object)false);
        this.f_19804_.m_135372_(SLIM, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(RENDERER_TAG, (Object)new CompoundTag());
        this.f_19804_.m_135372_(SCALE_X, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(SCALE_Y, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(SCALE_Z, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(TITLE, (Object)"");
        this.f_19804_.m_135372_(COLLISION, (Object)true);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setTextColor(0xFFFFFF);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12322_;
    }

    public String getTitle() {
        return (String)this.f_19804_.m_135370_(TITLE);
    }

    public Component getTitleComponent() {
        if (!this.getTitle().isEmpty() && this.titleComponent == TextComponent.f_131282_) {
            this.titleComponent = new TextComponent(this.getTitle()).m_130940_(ChatFormatting.ITALIC);
        }
        return this.titleComponent;
    }

    public boolean isTitleVisible() {
        return !this.getTitle().isEmpty() && !this.getTitle().isBlank();
    }

    public String getDialogue() {
        return (String)this.f_19804_.m_135370_(DIALOGUE);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        float horizontalScale = Math.max(this.getScaleX(), this.getScaleZ());
        if (this.renderedEntity == null) {
            return POSES.getOrDefault(pose, Player.f_36088_).m_20390_(horizontalScale, this.getScaleY());
        }
        return this.renderedEntity.m_6972_(pose).m_20390_(horizontalScale, this.getScaleY());
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        if (damageSourceIn == DamageSource.f_19307_) {
            return SoundEvents.f_12273_;
        }
        if (damageSourceIn == DamageSource.f_19312_) {
            return SoundEvents.f_12324_;
        }
        return damageSourceIn == DamageSource.f_19325_ ? SoundEvents.f_12274_ : SoundEvents.f_12323_;
    }

    public TradeOffers getOffers() {
        if (this.tradeOffers == null) {
            this.tradeOffers = new TradeOffers();
        }
        if (this.tradeOffers.size() < 12) {
            for (int i = this.tradeOffers.size(); i < 12; ++i) {
                this.tradeOffers.add(new TradeOffer());
            }
        }
        return this.tradeOffers;
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.f_19804_.m_135370_(ORIGIN);
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.PLAYERS;
    }

    protected float m_6431_(@NotNull Pose poseIn, @NotNull EntityDimensions sizeIn) {
        if (this.renderedEntity == null) {
            return switch (poseIn) {
                case Pose.SWIMMING, Pose.FALL_FLYING -> 0.4f;
                case Pose.SPIN_ATTACK -> 1.1f;
                case Pose.CROUCHING -> 1.27f;
                default -> 1.62f;
            };
        }
        return this.renderedEntity.getEyeHeightAccess(poseIn, sizeIn);
    }

    @NotNull
    protected SoundEvent m_5508_() {
        return SoundEvents.f_12278_;
    }

    @NotNull
    protected SoundEvent m_5501_() {
        return SoundEvents.f_12279_;
    }

    @NotNull
    protected SoundEvent m_5509_() {
        return SoundEvents.f_12277_;
    }

    @Nullable
    public Player getTalkingPlayer() {
        return this.talkingPlayer;
    }

    public int getTextColor() {
        return (Integer)this.f_19804_.m_135370_(TEXTCOLOR);
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 vec, InteractionHand hand) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND) && player.m_6084_()) {
            IQuestCapability questCapability = QuestCapabilityProvider.getCapability(player);
            ArrayList<QuestInstance> markedForCompletion = new ArrayList<QuestInstance>();
            for (QuestInstance questInstance : questCapability.getAcceptedQuests()) {
                if (questInstance.getTurnInType() != QuestInstance.TurnInType.QuestGiver && questInstance.getTurnInType() != QuestInstance.TurnInType.NpcByUuid || !questInstance.getPickedUpFrom().equals(this.m_142081_()) || !questInstance.getQuest().canComplete()) continue;
                markedForCompletion.add(questInstance);
            }
            for (QuestInstance questInstance : markedForCompletion) {
                questCapability.completeQuest(questInstance);
                if (this.f_19853_.f_46443_) continue;
                PacketDispatcher.sendTo(new SCompleteQuest(questInstance.getQuest().getName(), questInstance.getPickedUpFrom()), player);
            }
            if (markedForCompletion.isEmpty()) {
                String dialogueName = this.getDialogue();
                if (!dialogueName.isEmpty()) {
                    if (!(player.m_21120_(hand).m_41720_() instanceof NpcEditorItem) && !(player.m_21120_(hand).m_41720_() instanceof NpcSaveToolItem)) {
                        if (player.f_19853_.f_46443_) {
                            PacketDispatcher.sendToServer(new CRequestDialogue(dialogueName, this.m_142049_()));
                        }
                    } else if (!(player.m_21120_(hand).m_41720_() instanceof NpcSaveToolItem) && player.m_7500_() && player.m_6144_() && player.f_19853_.f_46443_) {
                        PacketDispatcher.sendToServer(new CRequestDialogue(dialogueName, this.m_142049_()));
                        PacketDispatcher.sendToServer(new CRequestDialogueEditor(dialogueName, this.m_142049_()));
                    }
                } else if (!(player.m_21120_(hand).m_41720_() instanceof NpcEditorItem) && !(player.m_21120_(hand).m_41720_() instanceof NpcSaveToolItem) && player.f_19853_.f_46443_) {
                    PacketDispatcher.sendToServer(new CRequestTrades(this.m_142049_()));
                }
            }
        }
        return InteractionResult.PASS;
    }

    private JsonObject inventoryToJson() {
        JsonObject inventory = new JsonObject();
        inventory.addProperty("mainHand", ItemUtil.stackToString(this.m_21205_()));
        inventory.addProperty("offHand", ItemUtil.stackToString(this.m_21206_()));
        inventory.addProperty("head", ItemUtil.stackToString(this.m_6844_(EquipmentSlot.HEAD)));
        inventory.addProperty("chest", ItemUtil.stackToString(this.m_6844_(EquipmentSlot.CHEST)));
        inventory.addProperty("legs", ItemUtil.stackToString(this.m_6844_(EquipmentSlot.LEGS)));
        inventory.addProperty("feet", ItemUtil.stackToString(this.m_6844_(EquipmentSlot.FEET)));
        return inventory;
    }

    public boolean m_6047_() {
        return (Boolean)this.f_19804_.m_135370_(CROUCHING);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public boolean isSlim() {
        return (Boolean)this.f_19804_.m_135370_(SLIM);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(1, (Goal)new TalkWithPlayerGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void setCrouching(boolean b) {
        this.f_19804_.m_135381_(CROUCHING, (Object)b);
        if (b) {
            this.m_20124_(Pose.CROUCHING);
        } else {
            this.m_20124_(this.isSitting() ? Pose.SPIN_ATTACK : Pose.STANDING);
        }
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    public void setTitle(String s) {
        this.f_19804_.m_135381_(TITLE, (Object)s);
        this.titleComponent = new TextComponent(s).m_130940_(ChatFormatting.ITALIC);
    }

    public void setDialogue(String s) {
        this.f_19804_.m_135381_(DIALOGUE, (Object)s);
    }

    public void setOrigin(BlockPos pos) {
        this.f_19804_.m_135381_(ORIGIN, (Object)pos);
    }

    public void setSitting(boolean b) {
        this.f_19804_.m_135381_(SITTING, (Object)b);
        if (b) {
            this.m_20124_(Pose.SPIN_ATTACK);
        } else {
            this.m_20124_(this.m_6047_() ? Pose.CROUCHING : Pose.STANDING);
        }
    }

    public void setSlim(boolean b) {
        this.f_19804_.m_135381_(SLIM, (Object)b);
    }

    public void setTalkingPlayer(@Nullable Player player) {
        this.talkingPlayer = player;
    }

    public void setTextColor(int i) {
        this.f_19804_.m_135381_(TEXTCOLOR, (Object)i);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setTradeOffers(@Nullable TradeOffers tradeOffers) {
        this.tradeOffers = tradeOffers;
    }

    public boolean m_7313_(@NotNull Entity entityIn) {
        Player player;
        if (entityIn instanceof Player && PermissionHelper.hasPermission(player = (Player)entityIn, PermissionHelper.EDIT_NPC) && player.m_7500_() && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof NpcEditorItem) {
            this.m_6074_();
        }
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            if (!this.f_19853_.f_46443_) {
                if (this.getOrigin().equals((Object)BlockPos.f_121853_)) {
                    this.setOrigin(this.m_142538_());
                }
                ++this.teleportCounter;
                if (this.teleportCounter > 300) {
                    this.teleportCounter = 0;
                    BlockPos origin = this.getOrigin();
                    if (!this.m_142538_().m_123314_((Vec3i)origin, 1.0)) {
                        this.m_6034_((double)origin.m_123341_() + 0.5, (double)origin.m_123342_() + 0.5, (double)origin.m_123343_() + 0.5);
                    }
                }
            } else {
                this.setRenderedEntityItems();
            }
        }
    }

    public boolean hasCollision() {
        return (Boolean)this.f_19804_.m_135370_(COLLISION);
    }

    public void setCollision(boolean collision) {
        this.f_19804_.m_135381_(COLLISION, (Object)collision);
    }

    public boolean m_6094_() {
        return this.hasCollision();
    }

    protected void m_6138_() {
        if (this.hasCollision()) {
            super.m_6138_();
        }
    }

    public float getScaleX() {
        return ((Float)this.f_19804_.m_135370_(SCALE_X)).floatValue();
    }

    public float getScaleY() {
        return ((Float)this.f_19804_.m_135370_(SCALE_Y)).floatValue();
    }

    public float getScaleZ() {
        return ((Float)this.f_19804_.m_135370_(SCALE_Z)).floatValue();
    }

    public void setScale(float x, float y, float z) {
        if (x < 0.1f || y < 0.1f || z < 0.1f || x > 15.0f || y > 15.0f || z > 15.0f) {
            return;
        }
        this.f_19804_.m_135381_(SCALE_X, (Object)Float.valueOf(x));
        this.f_19804_.m_135381_(SCALE_Y, (Object)Float.valueOf(y));
        this.f_19804_.m_135381_(SCALE_Z, (Object)Float.valueOf(z));
        this.m_6210_();
    }

    public String getRenderedEntityTypeKey() {
        CompoundTag tag = this.getRenderedEntityTagWithId();
        return tag.m_128441_("id") ? tag.m_128461_("id") : TYPE_STRING;
    }

    public CompoundTag getRenderedEntityTagWithId() {
        return (CompoundTag)this.f_19804_.m_135370_(RENDERER_TAG);
    }

    public CompoundTag getRenderedEntityTagWithoutId() {
        CompoundTag tag = this.getRenderedEntityTagWithId().m_6426_();
        tag.m_128473_("id");
        return tag;
    }

    public LivingEntity getRenderedEntity() {
        if (this.renderedEntity == null || this.renderedEntity.m_6095_() != this.getRenderedEntityType() || !this.getRenderedEntityTagWithId().equals((Object)this.prevRenderedEntityTag)) {
            this.setRenderedEntityFromTag(this.getRenderedEntityTagWithId());
        }
        return this.renderedEntity;
    }

    public EntityType<?> getRenderedEntityType() {
        String entityTypeKey = this.getRenderedEntityTypeKey();
        if (entityTypeKey.equals(TYPE_STRING)) {
            return this.m_6095_();
        }
        return EntityType.m_20632_((String)entityTypeKey).orElse(this.m_6095_());
    }

    public void clearRenderedEntity() {
        this.setRenderedEntityFromTag(new CompoundTag());
    }

    public void setRenderedEntityFromTag(CompoundTag tag) {
        if (!tag.m_128441_("id") || tag.m_128461_("id").isBlank() || tag.m_128461_("id").equals(TYPE_STRING)) {
            this.renderedEntity = null;
            this.prevRenderedEntityTag = null;
            this.f_19804_.m_135381_(RENDERER_TAG, (Object)new CompoundTag());
            this.m_6210_();
            return;
        }
        Optional entityOpt = EntityType.m_20642_((CompoundTag)tag, (Level)this.f_19853_);
        if (entityOpt.isPresent()) {
            this.prevRenderedEntityTag = tag;
            this.f_19804_.m_135381_(RENDERER_TAG, (Object)tag);
            this.renderedEntity = (LivingEntity)entityOpt.get();
            this.setRenderedEntityItems();
            this.m_6210_();
        }
    }

    public void setRenderedEntityItems() {
        if (this.renderedEntity != null) {
            this.renderedEntity.m_8061_(EquipmentSlot.MAINHAND, this.m_6844_(EquipmentSlot.MAINHAND));
            this.renderedEntity.m_8061_(EquipmentSlot.OFFHAND, this.m_6844_(EquipmentSlot.OFFHAND));
            this.renderedEntity.m_8061_(EquipmentSlot.HEAD, this.m_6844_(EquipmentSlot.HEAD));
            this.renderedEntity.m_8061_(EquipmentSlot.CHEST, this.m_6844_(EquipmentSlot.CHEST));
            this.renderedEntity.m_8061_(EquipmentSlot.LEGS, this.m_6844_(EquipmentSlot.LEGS));
            this.renderedEntity.m_8061_(EquipmentSlot.FEET, this.m_6844_(EquipmentSlot.FEET));
        }
    }

    public boolean isModelPartShown(PlayerModelPart part) {
        return true;
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public boolean isTextureResourceLocation() {
        return (Boolean)this.f_19804_.m_135370_(IS_TEXTURE_RESOURCE_LOCATION);
    }

    public void setTexture(String s) {
        this.f_19804_.m_135381_(TEXTURE, (Object)s);
    }

    public void setIsTextureResourceLocation(boolean b) {
        this.f_19804_.m_135381_(IS_TEXTURE_RESOURCE_LOCATION, (Object)b);
    }
}

