/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.client.gui.screen.quests.QuestLogScreen;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.item.NpcEditorItem;
import flash.npcmod.item.NpcSaveToolItem;
import flash.npcmod.item.QuestEditorItem;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CHandleNpcEditorRightClick;
import flash.npcmod.network.packets.client.CHandleNpcSaveToolRightClick;
import flash.npcmod.network.packets.client.CRequestQuestEditor;
import flash.npcmod.network.packets.client.CTrackQuest;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    public static final ResourceLocation QUEST_COMPLETE_ICON = new ResourceLocation("flashnpcs", "textures/render/icons/complete_quest.png");
    public static final ResourceLocation QUEST_IN_PROGRESS_ICON = new ResourceLocation("flashnpcs", "textures/render/icons/in_progress_quest.png");
    public static final ResourceLocation QUEST_ICON = new ResourceLocation("flashnpcs", "textures/render/icons/new_quest.png");

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        LocalPlayer player = ClientEvents.minecraft.f_91074_;
        if (minecraft.m_91302_() && player != null && player.m_6084_() && event.getAction() == 1) {
            for (KeyBindings keyBind : KeyBindings.values()) {
                if (!keyBind.get().m_90859_()) continue;
                keyBind.onPress();
            }
        }
    }

    @SubscribeEvent
    public void onClick(InputEvent.ClickInputEvent event) {
        if (ClientEvents.minecraft.f_91074_ != null && ClientEvents.minecraft.f_91074_.m_6084_() && event.isUseItem()) {
            ItemStack stack = ClientEvents.minecraft.f_91074_.m_21120_(event.getHand());
            if (ClientEvents.minecraft.f_91074_.m_7500_()) {
                if (stack.m_41720_() instanceof NpcEditorItem) {
                    HitResult rayTraceResult = ClientEvents.minecraft.f_91077_;
                    if (rayTraceResult.m_6662_().equals((Object)HitResult.Type.MISS)) {
                        if (ClientEvents.minecraft.f_91074_.m_20163_()) {
                            PacketDispatcher.sendToServer(new CHandleNpcEditorRightClick());
                        } else {
                            PacketDispatcher.sendToServer(new CHandleNpcEditorRightClick(""));
                        }
                    } else if (rayTraceResult.m_6662_().equals((Object)HitResult.Type.ENTITY)) {
                        EntityHitResult result = (EntityHitResult)rayTraceResult;
                        Entity entity = result.m_82443_();
                        if (entity instanceof NpcEntity) {
                            PacketDispatcher.sendToServer(new CHandleNpcEditorRightClick(entity.m_142049_()));
                        }
                    } else if (rayTraceResult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                        BlockHitResult result = (BlockHitResult)rayTraceResult;
                        BlockPos pos = result.m_82425_();
                        PacketDispatcher.sendToServer(new CHandleNpcEditorRightClick(pos));
                    }
                } else if (stack.m_41720_() instanceof QuestEditorItem) {
                    PacketDispatcher.sendToServer(new CRequestQuestEditor());
                } else if (stack.m_41720_() instanceof NpcSaveToolItem && ClientEvents.minecraft.f_91074_.m_20163_()) {
                    HitResult rayTraceResult = ClientEvents.minecraft.f_91077_;
                    if (rayTraceResult.m_6662_().equals((Object)HitResult.Type.ENTITY)) {
                        EntityHitResult result = (EntityHitResult)rayTraceResult;
                        Entity entity = result.m_82443_();
                        if (entity instanceof NpcEntity) {
                            PacketDispatcher.sendToServer(new CHandleNpcSaveToolRightClick(entity.m_142049_()));
                        }
                    } else if (rayTraceResult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                        BlockHitResult result = (BlockHitResult)rayTraceResult;
                        BlockPos pos = result.m_82425_();
                        PacketDispatcher.sendToServer(new CHandleNpcSaveToolRightClick(pos));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void renderQuestIconAboveNpc(RenderNameplateEvent event) {
        if (ClientEvents.minecraft.f_91074_ == null || !ClientEvents.minecraft.f_91074_.m_6084_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof NpcEntity)) {
            return;
        }
        NpcEntity npcEntity = (NpcEntity)entity;
        IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)ClientEvents.minecraft.f_91074_);
        boolean shouldDrawIcon = false;
        boolean canComplete = false;
        ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
        Iterator iterator = acceptedQuests.iterator();
        if (iterator.hasNext()) {
            QuestInstance instance = (QuestInstance)iterator.next();
            if (instance.getPickedUpFrom().equals(npcEntity.m_142081_())) {
                shouldDrawIcon = true;
            }
            canComplete = instance.getQuest().canComplete();
        }
        if (!shouldDrawIcon) {
            return;
        }
        PoseStack matrixStack = event.getPoseStack();
        MultiBufferSource bufferIn = event.getMultiBufferSource();
        int lightIn = event.getPackedLight();
        float partialTicks = event.getPartialTick();
        this.renderIcon(npcEntity, matrixStack, bufferIn, lightIn, partialTicks, canComplete);
    }

    protected void renderIcon(NpcEntity npcEntity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, float partialTicks, boolean canComplete) {
        ResourceLocation icon = canComplete ? QUEST_COMPLETE_ICON : QUEST_IN_PROGRESS_ICON;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, (double)npcEntity.m_20206_() + 0.5, 0.0);
        matrixStackIn.m_85845_(minecraft.m_91290_().m_114470_());
        matrixStackIn.m_85841_(-0.025f, -0.025f, 0.025f);
        matrixStackIn.m_85837_(0.0, -1.0, 0.0);
        float size = 12.0f;
        float xOffset = -size / 2.0f;
        float yOffset = -4.0f - size - Mth.m_14031_((float)(((float)npcEntity.f_19797_ + partialTicks) / 10.0f)) - (float)(npcEntity.isTitleVisible() ? 10 : 0);
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110497_((ResourceLocation)icon));
        int alpha = 32;
        if (npcEntity.m_20163_()) {
            ClientEvents.vertex(builder, matrixStackIn, xOffset, yOffset + size, 0.0f, 0.0f, 1.0f, alpha, packedLightIn);
            ClientEvents.vertex(builder, matrixStackIn, xOffset + size, yOffset + size, 0.0f, 1.0f, 1.0f, alpha, packedLightIn);
            ClientEvents.vertex(builder, matrixStackIn, xOffset + size, yOffset, 0.0f, 1.0f, 0.0f, alpha, packedLightIn);
            ClientEvents.vertex(builder, matrixStackIn, xOffset, yOffset, 0.0f, 0.0f, 0.0f, alpha, packedLightIn);
        } else {
            ClientEvents.vertex(builder, matrixStackIn, xOffset, yOffset + size, 0.0f, 0.0f, 1.0f, packedLightIn);
            ClientEvents.vertex(builder, matrixStackIn, xOffset + size, yOffset + size, 0.0f, 1.0f, 1.0f, packedLightIn);
            ClientEvents.vertex(builder, matrixStackIn, xOffset + size, yOffset, 0.0f, 1.0f, 0.0f, packedLightIn);
            ClientEvents.vertex(builder, matrixStackIn, xOffset, yOffset, 0.0f, 0.0f, 0.0f, packedLightIn);
            VertexConsumer builderSeeThrough = bufferIn.m_6299_(RenderType.m_110500_((ResourceLocation)icon));
            ClientEvents.vertex(builderSeeThrough, matrixStackIn, xOffset, yOffset + size, 0.0f, 0.0f, 1.0f, alpha, packedLightIn);
            ClientEvents.vertex(builderSeeThrough, matrixStackIn, xOffset + size, yOffset + size, 0.0f, 1.0f, 1.0f, alpha, packedLightIn);
            ClientEvents.vertex(builderSeeThrough, matrixStackIn, xOffset + size, yOffset + 0.0f, 0.0f, 1.0f, 0.0f, alpha, packedLightIn);
            ClientEvents.vertex(builderSeeThrough, matrixStackIn, xOffset, yOffset + 0.0f, 0.0f, 0.0f, 0.0f, alpha, packedLightIn);
        }
        matrixStackIn.m_85849_();
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int light) {
        ClientEvents.vertex(builder, matrixStack, x, y, z, u, v, 255, light);
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int alpha, int light) {
        PoseStack.Pose entry = matrixStack.m_85850_();
        builder.m_85982_(entry.m_85861_(), x, y, z).m_6122_(255, 255, 255, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(entry.m_85864_(), 0.0f, 0.0f, -1.0f).m_5752_();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum KeyBindings {
        OPEN_QUEST_LOG("quest_log", 75){

            @Override
            public void onPress() {
                minecraft.m_91152_((Screen)new QuestLogScreen());
            }
        }
        ,
        UNTRACK("untrack", 46){

            @Override
            public void onPress() {
                PacketDispatcher.sendToServer(new CTrackQuest(""));
            }
        };

        KeyMapping keyBinding;

        private KeyBindings(String name, int keyCode) {
            this.keyBinding = new KeyMapping("key." + name, keyCode, "key.categories.flashnpcs");
        }

        public KeyMapping get() {
            return this.keyBinding;
        }

        public void onPress() {
        }
    }
}

