/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.events;

import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.core.ItemUtil;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.core.quests.QuestObjectiveTypes;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.server.SCompleteQuest;
import flash.npcmod.network.packets.server.SSyncQuestCapability;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class QuestEvents {
    @SubscribeEvent
    public void attach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(QuestCapabilityProvider.IDENTIFIER, (ICapabilityProvider)new QuestCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        IQuestCapability oldCap = QuestCapabilityProvider.getCapability(event.getOriginal());
        IQuestCapability newCap = QuestCapabilityProvider.getCapability(event.getPlayer());
        newCap.setTrackedQuest(oldCap.getTrackedQuest());
        newCap.setAcceptedQuests(oldCap.getAcceptedQuests());
        newCap.setCompletedQuests(oldCap.getCompletedQuests());
        newCap.setQuestProgressMap(oldCap.getQuestProgressMap());
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public void serverLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player != null && player.m_6084_()) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            capability.getAcceptedQuests().forEach(instance -> instance.setPlayer(player));
            QuestEvents.syncCapability(player);
        }
    }

    @SubscribeEvent
    public void changeDimesionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (player != null && player.m_6084_()) {
            QuestEvents.syncCapability(player);
        }
    }

    @SubscribeEvent
    public void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (player != null && player.m_6084_()) {
            QuestEvents.syncCapability(player);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player != null && player.m_6084_() && event.side.isServer()) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
            Map<QuestObjective, Integer> progressMap = capability.getQuestProgressMap();
            ArrayList<QuestInstance> markedForCompletion = new ArrayList<QuestInstance>();
            for (QuestInstance questInstance : acceptedQuests) {
                if (questInstance.getTurnInType() == QuestInstance.TurnInType.AutoTurnIn && questInstance.getQuest().canComplete()) {
                    markedForCompletion.add(questInstance);
                }
                List<QuestObjective> objectives = questInstance.getQuest().getObjectives();
                for (QuestObjective objective : objectives) {
                    if (!objective.isHidden()) {
                        QuestObjective.ObjectiveType type = objective.getType();
                        switch (type) {
                            case Gather: {
                                ItemStack gatherStack = (ItemStack)objective.getObjective();
                                int progress = ItemUtil.getAmount(player, gatherStack);
                                objective.setProgress(progress);
                                break;
                            }
                            case Find: {
                                BlockPos[] area = (BlockPos[])objective.getObjective();
                                if (!QuestEvents.isPlayerInArea(player, area)) break;
                                objective.setProgress(objective.getAmount());
                                break;
                            }
                            case DeliverToLocation: {
                                ItemStack toDeliver = (ItemStack)objective.getObjective();
                                BlockPos[] deliveryArea = (BlockPos[])objective.getSecondaryObjective();
                                if (!QuestEvents.isPlayerInArea(player, deliveryArea) || !ItemUtil.hasItem(player, toDeliver)) break;
                                int prevProgress = objective.getProgress();
                                objective.progress(ItemUtil.getAmount(player, toDeliver));
                                ItemUtil.takeStack(player, toDeliver, objective.getAmount() - prevProgress);
                                break;
                            }
                            case Scoreboard: {
                                Scoreboard scoreboard = player.m_36329_();
                                Objective scoreObjective = scoreboard.m_83469_(objective.primaryToString());
                                if (scoreObjective == null) break;
                                objective.setProgress(scoreboard.m_83471_(player.m_7755_().getString(), scoreObjective).m_83400_());
                            }
                        }
                        if (objective.isComplete()) {
                            objective.onComplete(player);
                        }
                    }
                    progressMap.put(objective, objective.getProgress());
                }
            }
            PacketDispatcher.sendTo(new SSyncQuestCapability(capability.getAcceptedQuests().toArray(new QuestInstance[0])), player);
            for (QuestInstance questInstance : markedForCompletion) {
                capability.completeQuest(questInstance);
                PacketDispatcher.sendTo(new SCompleteQuest(questInstance.getQuest().getName(), questInstance.getPickedUpFrom()), player);
            }
        }
    }

    @SubscribeEvent
    public void livingDeathEvent(LivingDeathEvent event) {
        Player player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_6084_() && !player.f_19853_.f_46443_) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            Map<QuestObjective, Integer> progressMap = capability.getQuestProgressMap();
            for (QuestObjective objective : progressMap.keySet()) {
                if (objective.isHidden() || !objective.getType().equals((Object)QuestObjective.ObjectiveType.Kill) || !QuestEvents.areEntitiesEqual((Entity)event.getEntityLiving(), objective)) continue;
                objective.progress(1);
            }
        }
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent.EntityInteractSpecific event) {
        Player player = event.getPlayer();
        if (player != null && player.m_6084_() && event.getSide().isServer()) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
            for (QuestInstance questInstance : acceptedQuests) {
                List<QuestObjective> objectives = questInstance.getQuest().getObjectives();
                for (QuestObjective objective : objectives) {
                    if (objective.isHidden()) continue;
                    QuestObjective.ObjectiveType type = objective.getType();
                    switch (type) {
                        case DeliverToEntity: {
                            if (!ItemUtil.matches((ItemStack)objective.getObjective(), event.getItemStack()) || !QuestEvents.areEntitiesEqual(event.getTarget(), objective)) break;
                            int prevProgress = objective.getProgress();
                            objective.progress(ItemUtil.getAmount(player, (ItemStack)objective.getObjective()));
                            ItemUtil.takeStack(player, (ItemStack)objective.getObjective(), objective.getAmount() - prevProgress);
                            break;
                        }
                        case UseOnEntity: {
                            if (!ItemUtil.matches((ItemStack)objective.getObjective(), event.getItemStack()) || !QuestEvents.areEntitiesEqual(event.getTarget(), objective)) break;
                            objective.progress(1);
                            break;
                        }
                        case Use: {
                            if (event.getItemStack().m_41779_() != 0 || !ItemUtil.matches((ItemStack)objective.getObjective(), event.getItemStack())) break;
                            objective.progress(1);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void blockInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (player != null && player.m_6084_() && event.getSide().isServer()) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
            for (QuestInstance questInstance : acceptedQuests) {
                List<QuestObjective> objectives = questInstance.getQuest().getObjectives();
                for (QuestObjective objective : objectives) {
                    if (objective.isHidden()) continue;
                    if (objective.getType().equals((Object)QuestObjective.ObjectiveType.UseOnBlock)) {
                        if (!ItemUtil.matches((ItemStack)objective.getObjective(), event.getItemStack()) || !event.getWorld().m_8055_(event.getHitVec().m_82425_()).equals(objective.getSecondaryObjective())) continue;
                        objective.progress(1);
                        continue;
                    }
                    if (!objective.getType().equals((Object)QuestObjective.ObjectiveType.Use) || event.getItemStack().m_41779_() != 0 || !ItemUtil.matches((ItemStack)objective.getObjective(), event.getItemStack())) continue;
                    objective.progress(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void itemUse(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack;
        Player player;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof Player && (player = (Player)entity).m_6084_() && event.getSide().isServer() && (itemStack = event.getItemStack()).m_41779_() == 0) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
            for (QuestInstance questInstance : acceptedQuests) {
                List<QuestObjective> objectives = questInstance.getQuest().getObjectives();
                for (QuestObjective objective : objectives) {
                    if (objective.isHidden() || !objective.getType().equals((Object)QuestObjective.ObjectiveType.Use) || !ItemUtil.matches((ItemStack)objective.getObjective(), itemStack)) continue;
                    objective.progress(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void itemUse(LivingEntityUseItemEvent.Finish event) {
        ItemStack itemStack;
        Player player;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof Player && (player = (Player)entity).m_6084_() && !player.f_19853_.f_46443_ && (itemStack = event.getItem()).m_41779_() > 0) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
            for (QuestInstance questInstance : acceptedQuests) {
                List<QuestObjective> objectives = questInstance.getQuest().getObjectives();
                for (QuestObjective objective : objectives) {
                    if (objective.isHidden() || !objective.getType().equals((Object)QuestObjective.ObjectiveType.Use) || !ItemUtil.matches((ItemStack)objective.getObjective(), itemStack)) continue;
                    objective.progress(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void itemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getPlayer();
        if (player.m_6084_() && !player.f_19853_.f_46443_) {
            ItemStack itemStack = event.getCrafting();
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
            for (QuestInstance questInstance : acceptedQuests) {
                List<QuestObjective> objectives = questInstance.getQuest().getObjectives();
                for (QuestObjective objective : objectives) {
                    if (objective.isHidden() || !objective.getType().equals((Object)QuestObjective.ObjectiveType.CraftItem) || !ItemUtil.matches((ItemStack)objective.getObjective(), itemStack)) continue;
                    objective.progress(itemStack.m_41613_());
                }
            }
        }
    }

    @SubscribeEvent
    public void itemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        Player player = event.getPlayer();
        if (player.m_6084_() && !player.f_19853_.f_46443_) {
            ItemStack itemStack = event.getSmelting();
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
            for (QuestInstance questInstance : acceptedQuests) {
                List<QuestObjective> objectives = questInstance.getQuest().getObjectives();
                for (QuestObjective objective : objectives) {
                    if (objective.isHidden() || !objective.getType().equals((Object)QuestObjective.ObjectiveType.SmeltItem) || !ItemUtil.matches((ItemStack)objective.getObjective(), itemStack)) continue;
                    objective.progress(itemStack.m_41613_());
                }
            }
        }
    }

    private static boolean isPlayerInArea(Player player, BlockPos[] area) {
        BlockPos corner1 = area[0];
        BlockPos corner2 = area[1];
        int x1 = Math.min(corner1.m_123341_(), corner2.m_123341_());
        int y1 = Math.min(corner1.m_123342_(), corner2.m_123342_());
        int z1 = Math.min(corner1.m_123343_(), corner2.m_123343_());
        int x2 = Math.max(corner1.m_123341_(), corner2.m_123341_());
        int y2 = Math.max(corner1.m_123342_(), corner2.m_123342_());
        int z2 = Math.max(corner1.m_123343_(), corner2.m_123343_());
        double playerX = player.m_20185_();
        double playerY = player.m_20186_();
        double playerZ = player.m_20189_();
        return playerX >= (double)x1 && playerX <= (double)x2 && playerY >= (double)y1 && playerY <= (double)y2 && playerZ >= (double)z1 && playerZ <= (double)z2;
    }

    private static void syncCapability(Player player) {
        IQuestCapability questCapability = QuestCapabilityProvider.getCapability(player);
        if (questCapability.getTrackedQuest() != null) {
            PacketDispatcher.sendTo(new SSyncQuestCapability(questCapability.getTrackedQuest()), player);
        }
        PacketDispatcher.sendTo(new SSyncQuestCapability(questCapability.getAcceptedQuests().toArray(new QuestInstance[0])), player);
        PacketDispatcher.sendTo(new SSyncQuestCapability(questCapability.getCompletedQuests().toArray(new String[0])), player);
    }

    private static boolean areEntitiesEqual(Entity entity, QuestObjective objective) {
        switch (objective.getType()) {
            case Kill: {
                QuestObjectiveTypes.KillObjective killObjective = (QuestObjectiveTypes.KillObjective)objective;
                return EntityType.m_20613_((EntityType)entity.m_6095_()).toString().equals(killObjective.getEntityKey()) && QuestEvents.doesTagContainTag(entity.m_20240_(new CompoundTag()), killObjective.getEntityTag());
            }
            case DeliverToEntity: {
                QuestObjectiveTypes.DeliverToEntityObjective deliverToEntityObjective = (QuestObjectiveTypes.DeliverToEntityObjective)objective;
                return EntityType.m_20613_((EntityType)entity.m_6095_()).toString().equals(deliverToEntityObjective.getEntityKey()) && entity.m_20240_(new CompoundTag()).equals((Object)deliverToEntityObjective.getEntityTag());
            }
            case UseOnEntity: {
                QuestObjectiveTypes.UseOnEntityObjective useOnEntityObjective = (QuestObjectiveTypes.UseOnEntityObjective)objective;
                return EntityType.m_20613_((EntityType)entity.m_6095_()).toString().equals(useOnEntityObjective.getEntityKey()) && entity.m_20240_(new CompoundTag()).equals((Object)useOnEntityObjective.getEntityTag());
            }
        }
        return false;
    }

    private static boolean doesTagContainTag(CompoundTag entityTag, CompoundTag checkTag) {
        Set checkTagKeys = checkTag.m_128431_();
        for (String key : checkTagKeys) {
            if (entityTag.m_128441_(key) && Objects.equals(checkTag.m_128423_(key), entityTag.m_128423_(key))) continue;
            return false;
        }
        return true;
    }
}

