/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import flash.npcmod.commands.Command;
import flash.npcmod.commands.DebugCommand;
import flash.npcmod.commands.DialoguesCommand;
import flash.npcmod.commands.FunctionsCommand;
import flash.npcmod.commands.QuestsCommand;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class CommandInit {
    public static DialoguesCommand DIALOGUES_COMMAND;
    public static DebugCommand DEBUG_COMMAND;
    public static FunctionsCommand FUNCTIONS_COMMAND;
    public static QuestsCommand QUESTS_COMMAND;

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection env) {
        DEBUG_COMMAND = CommandInit.registerCommand(DebugCommand::new, dispatcher, env);
        DIALOGUES_COMMAND = CommandInit.registerCommand(DialoguesCommand::new, dispatcher, env);
        FUNCTIONS_COMMAND = CommandInit.registerCommand(FunctionsCommand::new, dispatcher, env);
        QUESTS_COMMAND = CommandInit.registerCommand(QuestsCommand::new, dispatcher, env);
    }

    public static <T extends Command> T registerCommand(Supplier<T> supplier, CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection env) {
        Command command = (Command)supplier.get();
        if (!command.isDedicatedServerOnly() || env == Commands.CommandSelection.DEDICATED || env == Commands.CommandSelection.ALL) {
            LiteralArgumentBuilder builder = Commands.m_82127_((String)command.getName());
            builder.requires(sender -> sender.m_6761_(command.getRequiredPermissionLevel()));
            command.build((LiteralArgumentBuilder<CommandSourceStack>)builder);
            dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"flashnpcs").then((ArgumentBuilder)builder));
        }
        return (T)command;
    }
}

