/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.inventory.container;

import com.mojang.datafixers.util.Pair;
import flash.npcmod.core.PermissionHelper;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.init.ContainerInit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NpcInventoryContainer
extends AbstractContainerMenu {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private NpcEntity npcEntity;

    public NpcInventoryContainer(int id, Inventory inventory, int entityId) {
        super(ContainerInit.NPC_INVENTORY_CONTAINER, id);
        NpcEntity npcEntity;
        Entity entity = inventory.f_35978_.f_19853_.m_6815_(entityId);
        if (!(entity instanceof NpcEntity)) {
            return;
        }
        this.npcEntity = npcEntity = (NpcEntity)entity;
        final SimpleContainer npcInventory = new SimpleContainer(this.getNpcItems(npcEntity));
        this.m_38897_(new Slot((Container)npcInventory, 0, 115, 44){

            public void m_5852_(ItemStack stack) {
                npcEntity.m_8061_(EquipmentSlot.MAINHAND, stack);
                npcInventory.m_6596_();
                super.m_5852_(stack);
            }

            public ItemStack m_7993_() {
                return npcEntity.m_6844_(EquipmentSlot.MAINHAND);
            }
        });
        this.m_38897_(new Slot((Container)npcInventory, 1, 115, 62){

            public void m_5852_(ItemStack stack) {
                npcEntity.m_8061_(EquipmentSlot.OFFHAND, stack);
                npcInventory.m_6596_();
                super.m_5852_(stack);
            }

            public ItemStack m_7993_() {
                return npcEntity.m_6844_(EquipmentSlot.OFFHAND);
            }

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.m_38897_(new Slot((Container)npcInventory, 2 + k, 46, 8 + k * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)npcEntity);
                }

                public void m_5852_(ItemStack stack) {
                    npcEntity.m_8061_(equipmentslottype, stack);
                    npcInventory.m_6596_();
                    super.m_5852_(stack);
                }

                public ItemStack m_7993_() {
                    return npcEntity.m_6844_(equipmentslottype);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.m_20749_()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)inventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)inventory, i1, 8 + i1 * 18, 142));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return PermissionHelper.hasPermission(playerIn, PermissionHelper.EDIT_NPC);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            if (index < 6 ? !this.m_38903_(stackInSlot, 6, this.f_38839_.size(), true) : !this.m_38903_(stackInSlot, 0, 6, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    private ItemStack[] getNpcItems(NpcEntity npcEntity) {
        return new ItemStack[]{npcEntity.m_21205_(), npcEntity.m_21206_(), npcEntity.m_6844_(EquipmentSlot.HEAD), npcEntity.m_6844_(EquipmentSlot.CHEST), npcEntity.m_6844_(EquipmentSlot.LEGS), npcEntity.m_6844_(EquipmentSlot.FEET)};
    }

    public NpcEntity getNpcEntity() {
        return this.npcEntity;
    }
}

