/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.inventory.container;

import flash.npcmod.core.PermissionHelper;
import flash.npcmod.core.trades.TradeOffer;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.init.ContainerInit;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class NpcTradeEditorContainer
extends AbstractContainerMenu {
    private NpcEntity npcEntity;
    private SimpleContainer buyingItems;
    private SimpleContainer sellingItems;

    public NpcTradeEditorContainer(int id, Inventory inventory, int entityId) {
        super(ContainerInit.NPC_TRADE_EDITOR_CONTAINER, id);
        int itemIndex;
        int index;
        int i;
        NpcEntity npcEntity;
        Entity entity = inventory.f_35978_.f_19853_.m_6815_(entityId);
        if (!(entity instanceof NpcEntity)) {
            return;
        }
        this.npcEntity = npcEntity = (NpcEntity)entity;
        this.buyingItems = new SimpleContainer(36);
        this.sellingItems = new SimpleContainer(36);
        for (i = 0; i < 18; ++i) {
            index = i / 3;
            itemIndex = i % 3;
            this.m_38897_(this.getBuySlot(i, index, itemIndex));
            this.m_38897_(this.getBuySlot(i + 18, index + 6, itemIndex));
        }
        for (i = 0; i < 18; ++i) {
            index = i / 3;
            itemIndex = i % 3;
            this.m_38897_(this.getSellSlot(i, index, itemIndex));
            this.m_38897_(this.getSellSlot(i + 18, index + 6, itemIndex));
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)inventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)inventory, i1, 8 + i1 * 18, 142));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return PermissionHelper.hasPermission(playerIn, PermissionHelper.EDIT_NPC);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            if (index < 72 ? !this.m_38903_(stackInSlot, 72, this.f_38839_.size(), true) : !this.m_38903_(stackInSlot, 0, 72, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    private ItemStack getBuyingItem(int index, int itemIndex) {
        return ((TradeOffer)this.npcEntity.getOffers().get(index)).getBuyingStacks()[itemIndex];
    }

    private void setBuyingItem(int index, int itemIndex, ItemStack stack) {
        ((TradeOffer)this.npcEntity.getOffers().get(index)).setBuyingStack(itemIndex, stack);
    }

    private ItemStack getSellingItem(int index, int itemIndex) {
        return ((TradeOffer)this.npcEntity.getOffers().get(index)).getSellingStacks()[itemIndex];
    }

    private void setSellingItem(int index, int itemIndex, ItemStack stack) {
        ((TradeOffer)this.npcEntity.getOffers().get(index)).setSellingStack(itemIndex, stack);
    }

    private Slot getBuySlot(int slotIndex, final int rowIndex, final int itemIndex) {
        int x = slotIndex < 18 ? -64 : 92;
        int rowOffset = slotIndex < 18 ? rowIndex * 18 : (rowIndex - 6) * 18;
        return new Slot((Container)this.buyingItems, slotIndex, x + itemIndex * 18, -28 + rowOffset){

            public void m_5852_(ItemStack stack) {
                NpcTradeEditorContainer.this.setBuyingItem(rowIndex, itemIndex, stack);
                super.m_5852_(stack);
            }

            public ItemStack m_7993_() {
                return NpcTradeEditorContainer.this.getBuyingItem(rowIndex, itemIndex);
            }
        };
    }

    private Slot getSellSlot(int slotIndex, final int rowIndex, final int itemIndex) {
        int x = slotIndex < 18 ? 32 : 188;
        int rowOffset = slotIndex < 18 ? rowIndex * 18 : (rowIndex - 6) * 18;
        return new Slot((Container)this.sellingItems, slotIndex, x + itemIndex * 18, -28 + rowOffset){

            public void m_5852_(ItemStack stack) {
                NpcTradeEditorContainer.this.setSellingItem(rowIndex, itemIndex, stack);
                super.m_5852_(stack);
            }

            public ItemStack m_7993_() {
                return NpcTradeEditorContainer.this.getSellingItem(rowIndex, itemIndex);
            }
        };
    }

    public NpcEntity getNpcEntity() {
        return this.npcEntity;
    }
}

