/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.core.quests.QuestInstance;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CAbandonQuest {
    String name;
    UUID pickedUpFrom;

    public CAbandonQuest(QuestInstance questInstance) {
        this(questInstance.getQuest().getName(), questInstance.getPickedUpFrom());
    }

    public CAbandonQuest(String name, UUID pickedUpFrom) {
        this.name = name;
        this.pickedUpFrom = pickedUpFrom;
    }

    public static void encode(CAbandonQuest msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.name);
        buf.m_130077_(msg.pickedUpFrom);
    }

    public static CAbandonQuest decode(FriendlyByteBuf buf) {
        return new CAbandonQuest(buf.m_130136_(51), buf.m_130259_());
    }

    public static void handle(CAbandonQuest msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)sender);
            ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
            for (QuestInstance questInstance : acceptedQuests) {
                if (!questInstance.getQuest().getName().equals(msg.name) || !questInstance.getPickedUpFrom().equals(msg.pickedUpFrom)) continue;
                capability.abandonQuest(questInstance);
                break;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

