/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import flash.npcmod.core.PermissionHelper;
import flash.npcmod.core.quests.CommonQuestUtil;
import flash.npcmod.core.quests.Quest;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CBuildQuest {
    String name;
    String jsonText;

    public CBuildQuest(Quest quest) {
        this(quest.getName(), quest.toJson().toString());
    }

    public CBuildQuest(String name, String jsonText) {
        this.name = name;
        this.jsonText = jsonText;
    }

    public static void encode(CBuildQuest msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.name);
        buf.m_130070_(msg.jsonText);
    }

    public static CBuildQuest decode(FriendlyByteBuf buf) {
        return new CBuildQuest(buf.m_130136_(51), buf.m_130136_(100000));
    }

    public static void handle(CBuildQuest msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (PermissionHelper.hasPermission((Player)sender, PermissionHelper.EDIT_QUEST)) {
                CommonQuestUtil.buildQuest(msg.name, msg.jsonText);
                Quest quest = CommonQuestUtil.loadQuestFile(msg.name);
                if (quest != null) {
                    sender.m_5661_((Component)new TextComponent("Successfully built quest '" + msg.name + "'").m_130940_(ChatFormatting.GREEN), false);
                } else {
                    sender.m_5661_((Component)new TextComponent("Couldn't build quest '" + msg.name + "'").m_130940_(ChatFormatting.RED), false);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

