/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import flash.npcmod.core.PermissionHelper;
import flash.npcmod.entity.NpcEntity;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class CEditNpc {
    int entityid;
    String name;
    String title;
    String texture;
    String dialogue;
    boolean isSlim;
    boolean isNameVisible;
    boolean isTextureResourceLocation;
    int textColor;
    ItemStack[] items;
    NPCPose pose;
    String renderer;
    CompoundTag rendererTag;
    float scaleX;
    float scaleY;
    float scaleZ;
    boolean collision;

    public CEditNpc(int entityid, boolean isNameVisible, String name, String title, String texture, boolean isTextureResourceLocation, boolean isSlim, String dialogue, int textColor, ItemStack[] items, NPCPose pose, EntityType<?> renderer, CompoundTag rendererTag, float scaleX, float scaleY, float scaleZ, boolean collision) {
        this(entityid, isNameVisible, name, title, texture, isTextureResourceLocation, isSlim, dialogue, textColor, items, pose, EntityType.m_20613_(renderer).toString(), rendererTag, scaleX, scaleY, scaleZ, collision);
    }

    public CEditNpc(int entityid, boolean isNameVisible, String name, String title, String texture, boolean isTextureResourceLocation, boolean isSlim, String dialogue, int textColor, ItemStack[] items, NPCPose pose, String renderer, CompoundTag rendererTag, float scaleX, float scaleY, float scaleZ, boolean collision) {
        this.entityid = entityid;
        this.isNameVisible = isNameVisible;
        this.name = name;
        this.title = title;
        this.texture = texture;
        this.isTextureResourceLocation = isTextureResourceLocation;
        this.isSlim = isSlim;
        this.dialogue = dialogue;
        this.textColor = textColor;
        if (items.length == 6) {
            this.items = items;
        }
        this.pose = pose;
        this.renderer = renderer;
        this.rendererTag = rendererTag;
        this.rendererTag.m_128359_("id", renderer);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.collision = collision;
    }

    public static void encode(CEditNpc msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityid);
        buf.writeBoolean(msg.isNameVisible);
        buf.m_130070_(msg.name);
        buf.m_130070_(msg.title);
        buf.m_130070_(msg.texture);
        buf.writeBoolean(msg.isTextureResourceLocation);
        buf.writeBoolean(msg.isSlim);
        buf.m_130070_(msg.dialogue);
        buf.writeInt(msg.textColor);
        buf.writeInt(msg.pose.ordinal());
        buf.m_130070_(msg.renderer);
        buf.m_130079_(msg.rendererTag);
        buf.writeFloat(msg.scaleX);
        buf.writeFloat(msg.scaleY);
        buf.writeFloat(msg.scaleZ);
        buf.writeBoolean(msg.collision);
        if (msg.items != null) {
            for (int i = 0; i < 6; ++i) {
                buf.m_130055_(msg.items[i]);
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                buf.m_130055_(ItemStack.f_41583_);
            }
        }
    }

    public static CEditNpc decode(FriendlyByteBuf buf) {
        int entityid = buf.readInt();
        boolean isNameVisible = buf.readBoolean();
        String name = buf.m_130136_(201);
        String title = buf.m_130136_(201);
        String texture = buf.m_130136_(201);
        boolean isTextureResourceLocation = buf.readBoolean();
        boolean isSlim = buf.readBoolean();
        String dialogue = buf.m_130136_(201);
        int textColor = buf.readInt();
        NPCPose pose = NPCPose.values()[buf.readInt()];
        String renderer = buf.m_130277_();
        CompoundTag rendererTag = buf.m_130261_();
        float scaleX = buf.readFloat();
        float scaleY = buf.readFloat();
        float scaleZ = buf.readFloat();
        boolean collision = buf.readBoolean();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            items.add(buf.m_130267_());
        }
        return new CEditNpc(entityid, isNameVisible, name, title, texture, isTextureResourceLocation, isSlim, dialogue, textColor, items.toArray(new ItemStack[0]), pose, renderer, rendererTag, scaleX, scaleY, scaleZ, collision);
    }

    public static void handle(CEditNpc msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (PermissionHelper.hasPermission((Player)sender, PermissionHelper.EDIT_NPC) && (entity = sender.f_19853_.m_6815_(msg.entityid)) instanceof NpcEntity) {
                NpcEntity npcEntity = (NpcEntity)entity;
                npcEntity.m_20340_(msg.isNameVisible);
                npcEntity.m_6593_((Component)new TextComponent(msg.name));
                npcEntity.setTitle(msg.title);
                npcEntity.setTexture(msg.texture);
                npcEntity.setIsTextureResourceLocation(msg.isTextureResourceLocation);
                npcEntity.setSlim(msg.isSlim);
                npcEntity.setDialogue(msg.dialogue);
                npcEntity.setTextColor(msg.textColor);
                npcEntity.setRenderedEntityFromTag(msg.rendererTag);
                npcEntity.m_8061_(EquipmentSlot.MAINHAND, msg.items[0]);
                npcEntity.m_8061_(EquipmentSlot.OFFHAND, msg.items[1]);
                npcEntity.m_8061_(EquipmentSlot.HEAD, msg.items[2]);
                npcEntity.m_8061_(EquipmentSlot.CHEST, msg.items[3]);
                npcEntity.m_8061_(EquipmentSlot.LEGS, msg.items[4]);
                npcEntity.m_8061_(EquipmentSlot.FEET, msg.items[5]);
                npcEntity.setRenderedEntityItems();
                if (msg.scaleX >= 0.1f && msg.scaleY >= 0.1f && msg.scaleZ >= 0.1f) {
                    npcEntity.setScale(msg.scaleX, msg.scaleY, msg.scaleZ);
                }
                npcEntity.setCollision(msg.collision);
                switch (msg.pose) {
                    case CROUCHING: {
                        npcEntity.setCrouching(true);
                        npcEntity.setSitting(false);
                        break;
                    }
                    case SITTING: {
                        npcEntity.setCrouching(false);
                        npcEntity.setSitting(true);
                        break;
                    }
                    case STANDING: {
                        npcEntity.setCrouching(false);
                        npcEntity.setSitting(false);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum NPCPose {
        STANDING,
        CROUCHING,
        SITTING;

    }
}

