/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import flash.npcmod.core.PermissionHelper;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.init.EntityInit;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.server.SOpenScreen;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkEvent;

public class CHandleNpcEditorRightClick {
    int handleType;
    int entityid;
    BlockPos pos;
    String fileName;

    public CHandleNpcEditorRightClick() {
        this.handleType = HandleType.AIR_SNEAK.ordinal();
    }

    public CHandleNpcEditorRightClick(String s) {
        this.handleType = HandleType.AIR.ordinal();
        this.fileName = s;
    }

    public CHandleNpcEditorRightClick(int entityid) {
        this.handleType = HandleType.ENTITY.ordinal();
        this.entityid = entityid;
    }

    public CHandleNpcEditorRightClick(BlockPos pos) {
        this.handleType = HandleType.BLOCK.ordinal();
        this.pos = pos;
    }

    public static void encode(CHandleNpcEditorRightClick msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.handleType);
        if (msg.handleType == HandleType.ENTITY.ordinal()) {
            buf.writeInt(msg.entityid);
        } else if (msg.handleType == HandleType.BLOCK.ordinal()) {
            buf.m_130064_(msg.pos);
        } else if (msg.handleType == HandleType.AIR.ordinal()) {
            buf.m_130070_(msg.fileName);
        }
    }

    public static CHandleNpcEditorRightClick decode(FriendlyByteBuf buf) {
        int handleType = buf.readInt();
        if (handleType == HandleType.ENTITY.ordinal()) {
            return new CHandleNpcEditorRightClick(buf.readInt());
        }
        if (handleType == HandleType.BLOCK.ordinal()) {
            return new CHandleNpcEditorRightClick(buf.m_130135_());
        }
        if (handleType == HandleType.AIR.ordinal()) {
            return new CHandleNpcEditorRightClick(buf.m_130277_());
        }
        return new CHandleNpcEditorRightClick();
    }

    public static void handle(CHandleNpcEditorRightClick msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (msg.handleType == HandleType.AIR_SNEAK.ordinal() && PermissionHelper.hasPermission((Player)sender, PermissionHelper.EDIT_FUNCTION)) {
                PacketDispatcher.sendTo(new SOpenScreen(SOpenScreen.EScreens.FUNCTIONBUILDER, "", 0), (Player)sender);
            } else if (msg.handleType == HandleType.ENTITY.ordinal() && PermissionHelper.hasPermission((Player)sender, PermissionHelper.EDIT_NPC)) {
                Entity entity = sender.f_19853_.m_6815_(msg.entityid);
                if (entity instanceof NpcEntity) {
                    PacketDispatcher.sendTo(new SOpenScreen(SOpenScreen.EScreens.EDITNPC, "", msg.entityid), (Player)sender);
                }
            } else if (msg.handleType == HandleType.BLOCK.ordinal() && PermissionHelper.hasPermission((Player)sender, PermissionHelper.EDIT_NPC)) {
                NpcEntity newNpc = (NpcEntity)((EntityType)EntityInit.NPC_ENTITY.get()).m_20615_(sender.f_19853_);
                BlockPos pos = msg.pos;
                VoxelShape collisionShape = sender.f_19853_.m_8055_(pos).m_60816_((BlockGetter)sender.f_19853_, pos);
                double blockHeight = collisionShape.m_83281_() ? 0.0 : collisionShape.m_83215_().f_82292_;
                newNpc.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + blockHeight, (double)pos.m_123343_() + 0.5);
                sender.f_19853_.m_7967_((Entity)newNpc);
                PacketDispatcher.sendTo(new SOpenScreen(SOpenScreen.EScreens.EDITNPC, "", newNpc.m_142049_()), (Player)sender);
            } else if (msg.handleType == HandleType.AIR.ordinal() && PermissionHelper.hasPermission((Player)sender, PermissionHelper.EDIT_DIALOGUE)) {
                PacketDispatcher.sendTo(new SOpenScreen(SOpenScreen.EScreens.EDITDIALOGUE, "", 0), (Player)sender);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum HandleType {
        ENTITY,
        AIR_SNEAK,
        AIR,
        BLOCK;

    }
}

