/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import flash.npcmod.core.PermissionHelper;
import flash.npcmod.core.saves.NpcSaveUtil;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CHandleNpcEditorRightClick;
import flash.npcmod.network.packets.server.SOpenScreen;
import flash.npcmod.network.packets.server.SSyncSavedNpcs;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CHandleNpcSaveToolRightClick {
    int handleType;
    int entityid;
    BlockPos pos;

    public CHandleNpcSaveToolRightClick() {
        this.handleType = CHandleNpcEditorRightClick.HandleType.AIR.ordinal();
    }

    public CHandleNpcSaveToolRightClick(int entityid) {
        this.handleType = CHandleNpcEditorRightClick.HandleType.ENTITY.ordinal();
        this.entityid = entityid;
    }

    public CHandleNpcSaveToolRightClick(BlockPos pos) {
        this.handleType = CHandleNpcEditorRightClick.HandleType.BLOCK.ordinal();
        this.pos = pos;
    }

    public static void encode(CHandleNpcSaveToolRightClick msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.handleType);
        if (msg.handleType == CHandleNpcEditorRightClick.HandleType.ENTITY.ordinal()) {
            buf.writeInt(msg.entityid);
        } else if (msg.handleType == CHandleNpcEditorRightClick.HandleType.BLOCK.ordinal()) {
            buf.m_130064_(msg.pos);
        }
    }

    public static CHandleNpcSaveToolRightClick decode(FriendlyByteBuf buf) {
        int handleType = buf.readInt();
        if (handleType == CHandleNpcEditorRightClick.HandleType.ENTITY.ordinal()) {
            return new CHandleNpcSaveToolRightClick(buf.readInt());
        }
        if (handleType == CHandleNpcEditorRightClick.HandleType.BLOCK.ordinal()) {
            return new CHandleNpcSaveToolRightClick(buf.m_130135_());
        }
        return new CHandleNpcSaveToolRightClick();
    }

    public static void handle(CHandleNpcSaveToolRightClick msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (PermissionHelper.hasPermission((Player)sender, PermissionHelper.SAVE_NPC) && sender.m_20163_()) {
                if (msg.handleType == CHandleNpcEditorRightClick.HandleType.ENTITY.ordinal()) {
                    Entity entity = sender.f_19853_.m_6815_(msg.entityid);
                    if (entity instanceof NpcEntity) {
                        NpcEntity npcEntity = (NpcEntity)entity;
                        NpcSaveUtil.BuildResult result = NpcSaveUtil.build(sender.m_20149_(), npcEntity.toJson().toString());
                        Object s = "";
                        ChatFormatting color = ChatFormatting.WHITE;
                        switch (result) {
                            case SUCCESS: {
                                s = "Successfully Saved " + npcEntity.m_7755_().getString();
                                color = ChatFormatting.GREEN;
                                break;
                            }
                            case TOOMANY: {
                                s = "You can only have " + NpcSaveUtil.MAX_SAVED_NPCS + " NPCs saved!";
                                color = ChatFormatting.RED;
                                break;
                            }
                            case FAILED: {
                                s = "Failed to save " + npcEntity.m_7755_().getString();
                                color = ChatFormatting.RED;
                                break;
                            }
                            case EXISTS: {
                                s = "You already have an NPC with this name saved. Please rename it!";
                                color = ChatFormatting.RED;
                            }
                        }
                        sender.m_5661_((Component)new TextComponent((String)s).m_6270_(Style.f_131099_.m_131157_(color)), true);
                    }
                } else if (msg.handleType == CHandleNpcEditorRightClick.HandleType.BLOCK.ordinal()) {
                    PacketDispatcher.sendTo(new SSyncSavedNpcs(NpcSaveUtil.loadGlobal(), true), (Player)sender);
                    PacketDispatcher.sendTo(new SSyncSavedNpcs(NpcSaveUtil.load(sender.m_20149_()), false), (Player)sender);
                    PacketDispatcher.sendTo(new SOpenScreen(SOpenScreen.EScreens.SAVEDNPCS, msg.pos.m_123341_() + ";" + msg.pos.m_123342_() + ";" + msg.pos.m_123343_(), msg.entityid), (Player)sender);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

