/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import flash.npcmod.core.PermissionHelper;
import flash.npcmod.core.saves.NpcSaveUtil;
import flash.npcmod.entity.NpcEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkEvent;

public class CHandleSavedNpc {
    PacketType type;
    String newName;
    String prevName;
    boolean isGlobal;
    JsonObject npcJson;
    BlockPos pos;

    public CHandleSavedNpc(String prevName, String newName, boolean isGlobal) {
        this.type = PacketType.RENAME;
        this.prevName = prevName;
        this.newName = newName;
        this.isGlobal = isGlobal;
    }

    public CHandleSavedNpc(JsonObject npcJson, BlockPos pos) {
        this.type = PacketType.PLACE;
        this.npcJson = npcJson;
        this.pos = pos;
    }

    public CHandleSavedNpc(JsonObject npcJson) {
        this.type = PacketType.GLOBAL_SAVE;
        this.npcJson = npcJson;
    }

    public CHandleSavedNpc(String toDelete, boolean isGlobal) {
        this.type = PacketType.DELETE;
        this.prevName = toDelete;
        this.isGlobal = isGlobal;
    }

    public static void encode(CHandleSavedNpc msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.type.ordinal());
        switch (msg.type) {
            case PLACE: {
                buf.m_130070_(msg.npcJson.toString());
                buf.m_130064_(msg.pos);
                break;
            }
            case RENAME: {
                buf.m_130070_(msg.prevName);
                buf.m_130070_(msg.newName);
                buf.writeBoolean(msg.isGlobal);
                break;
            }
            case DELETE: {
                buf.m_130070_(msg.prevName);
                buf.writeBoolean(msg.isGlobal);
                break;
            }
            case GLOBAL_SAVE: {
                buf.m_130070_(msg.npcJson.toString());
            }
        }
    }

    public static CHandleSavedNpc decode(FriendlyByteBuf buf) {
        PacketType type = PacketType.values()[buf.readInt()];
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PacketType.PLACE -> new CHandleSavedNpc((JsonObject)new Gson().fromJson(buf.m_130277_(), JsonObject.class), buf.m_130135_());
            case PacketType.RENAME -> new CHandleSavedNpc(buf.m_130277_(), buf.m_130277_(), buf.readBoolean());
            case PacketType.DELETE -> new CHandleSavedNpc(buf.m_130277_(), buf.readBoolean());
            case PacketType.GLOBAL_SAVE -> new CHandleSavedNpc((JsonObject)new Gson().fromJson(buf.m_130277_(), JsonObject.class));
        };
    }

    public static void handle(CHandleSavedNpc msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (PermissionHelper.hasPermission((Player)sender, PermissionHelper.SAVE_NPC) && sender.m_7500_()) {
                switch (msg.type) {
                    case PLACE: {
                        NpcEntity npcEntity = NpcEntity.fromJson(sender.f_19853_, msg.npcJson);
                        BlockPos pos = msg.pos;
                        VoxelShape collisionShape = sender.f_19853_.m_8055_(pos).m_60816_((BlockGetter)sender.f_19853_, pos);
                        double blockHeight = collisionShape.m_83281_() ? 0.0 : collisionShape.m_83215_().f_82292_;
                        npcEntity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + blockHeight, (double)pos.m_123343_() + 0.5);
                        sender.f_19853_.m_7967_((Entity)npcEntity);
                        break;
                    }
                    case RENAME: {
                        NpcSaveUtil.rename(sender.m_20149_(), msg.prevName, msg.newName, msg.isGlobal);
                        break;
                    }
                    case DELETE: {
                        NpcSaveUtil.delete(sender, msg.prevName, msg.isGlobal);
                        break;
                    }
                    case GLOBAL_SAVE: {
                        NpcSaveUtil.buildGlobal(msg.npcJson);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    static enum PacketType {
        RENAME,
        PLACE,
        DELETE,
        GLOBAL_SAVE;

    }
}

