/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import flash.npcmod.core.PermissionHelper;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.inventory.container.NpcInventoryContainer;
import flash.npcmod.inventory.container.NpcTradeContainer;
import flash.npcmod.inventory.container.NpcTradeEditorContainer;
import flash.npcmod.inventory.container.ObjectiveStackSelectorContainer;
import flash.npcmod.inventory.container.QuestStackSelectorContainer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.server.permission.nodes.PermissionNode;

public class CRequestContainer {
    int entityid;
    ContainerType containerType;
    String name;

    public CRequestContainer(int entityid, ContainerType type) {
        this.entityid = entityid;
        this.containerType = type;
    }

    public CRequestContainer(String name, ContainerType type) {
        this.name = name;
        this.entityid = -1000;
        this.containerType = type;
    }

    public static void encode(CRequestContainer msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.entityid == -1000);
        if (msg.entityid != -1000) {
            buf.writeInt(msg.entityid);
        } else {
            buf.m_130072_(msg.name, 100000);
        }
        buf.writeInt(msg.containerType.ordinal());
    }

    public static CRequestContainer decode(FriendlyByteBuf buf) {
        boolean isNamePacket = buf.readBoolean();
        if (isNamePacket) {
            String data = buf.m_130136_(100000);
            return new CRequestContainer(data, ContainerType.values()[buf.readInt()]);
        }
        return new CRequestContainer(buf.readInt(), ContainerType.values()[buf.readInt()]);
    }

    public static void handle(CRequestContainer msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (msg.containerType.requiredPermission() == null || PermissionHelper.hasPermission((Player)sender, msg.containerType.requiredPermission())) {
                if (msg.entityid != -1000) {
                    Entity entity = sender.f_19853_.m_6815_(msg.entityid);
                    if (entity instanceof NpcEntity) {
                        NpcEntity npcEntity = (NpcEntity)entity;
                        ContainerType.setEntityId(msg.entityid);
                        ContainerType.setName(npcEntity.m_7755_().getString());
                        NetworkHooks.openGui((ServerPlayer)sender, (MenuProvider)ContainerType.getContainerProvider(msg.containerType), packetBuffer -> packetBuffer.writeInt(msg.entityid));
                    }
                } else if (msg.containerType.equals((Object)ContainerType.OBJECTIVE_STACK_SELECTOR)) {
                    ContainerType.setName(msg.name);
                    String[] split = msg.name.split("::::::::::");
                    NetworkHooks.openGui((ServerPlayer)sender, (MenuProvider)ContainerType.getContainerProvider(msg.containerType), packetBuffer -> {
                        packetBuffer.m_130072_(split[0], 100000);
                        packetBuffer.m_130072_(split[1], 100000);
                        packetBuffer.m_130072_(split.length == 2 ? "" : split[2], 400);
                    });
                } else if (msg.containerType.equals((Object)ContainerType.QUEST_STACK_SELECTOR)) {
                    ContainerType.setName(msg.name);
                    NetworkHooks.openGui((ServerPlayer)sender, (MenuProvider)ContainerType.getContainerProvider(msg.containerType), packetBuffer -> packetBuffer.m_130072_(msg.name, 100000));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ContainerType {
        NPCINVENTORY((PermissionNode)PermissionHelper.EDIT_NPC){

            @Override
            public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
                return new NpcInventoryContainer(index, playerInventory, entityid);
            }
        }
        ,
        TRADES(null){

            @Override
            public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
                return new NpcTradeContainer(index, playerInventory, entityid);
            }
        }
        ,
        TRADE_EDITOR((PermissionNode)PermissionHelper.EDIT_NPC){

            @Override
            public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
                return new NpcTradeEditorContainer(index, playerInventory, entityid);
            }
        }
        ,
        OBJECTIVE_STACK_SELECTOR((PermissionNode)PermissionHelper.EDIT_QUEST){

            @Override
            public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
                return new ObjectiveStackSelectorContainer(index, playerInventory, this.objectiveFromString(name), this.questFromString(name), name.split("::::::::::").length == 2 ? "" : name.split("::::::::::")[2]);
            }

            private QuestObjective objectiveFromString(String name) {
                JsonObject jsonObject = (JsonObject)new Gson().fromJson(name.split("::::::::::")[0], JsonObject.class);
                return QuestObjective.fromJson(jsonObject);
            }

            private Quest questFromString(String name) {
                JsonObject jsonObject = (JsonObject)new Gson().fromJson(name.split("::::::::::")[1], JsonObject.class);
                return Quest.fromJson(jsonObject);
            }
        }
        ,
        QUEST_STACK_SELECTOR((PermissionNode)PermissionHelper.EDIT_QUEST){

            @Override
            public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
                return new QuestStackSelectorContainer(index, playerInventory, this.questFromString(name));
            }

            private Quest questFromString(String name) {
                JsonObject jsonObject = (JsonObject)new Gson().fromJson(name, JsonObject.class);
                return Quest.fromJson(jsonObject);
            }
        };

        private static String name;
        private static int entityid;
        private final PermissionNode<Boolean> requiredPermission;

        private ContainerType(PermissionNode<Boolean> requiredPermission) {
            this.requiredPermission = requiredPermission;
        }

        @Nullable
        public PermissionNode<Boolean> requiredPermission() {
            return this.requiredPermission;
        }

        @Nullable
        public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
            return null;
        }

        public static void setName(String newName) {
            name = newName;
        }

        public static void setEntityId(int newId) {
            entityid = newId;
        }

        public static MenuProvider getContainerProvider(final ContainerType type) {
            MenuProvider containerProvider = new MenuProvider(){

                public Component m_5446_() {
                    return new TextComponent(name);
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int index, Inventory playerInventory, Player player) {
                    return type.createMenu(index, playerInventory, player);
                }
            };
            return containerProvider;
        }
    }
}

