/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import com.google.gson.JsonObject;
import flash.npcmod.core.dialogues.CommonDialogueUtil;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.server.SOpenScreen;
import flash.npcmod.network.packets.server.SSendDialogue;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CRequestDialogue {
    String name;
    int entityid;

    public CRequestDialogue(String name) {
        this(name, -1000);
    }

    public CRequestDialogue(String name, int entityid) {
        this.name = name;
        this.entityid = entityid;
    }

    public static void encode(CRequestDialogue msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.name);
        buf.writeInt(msg.entityid);
    }

    public static CRequestDialogue decode(FriendlyByteBuf buf) {
        return new CRequestDialogue(buf.m_130136_(100000), buf.readInt());
    }

    public static void handle(CRequestDialogue msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            JsonObject dialogue = CommonDialogueUtil.loadDialogueFile(msg.name);
            if (dialogue != null) {
                PacketDispatcher.sendTo(new SSendDialogue(msg.name, dialogue.toString()), (Player)sender);
            } else {
                Entity entity;
                String dialogueJson = "{\"name\":\"init\",\"text\":\"Hi @p!\",\"function\":\"\",\"children\":[{\"name\":\"hello\",\"text\":\"Hey @npc.\"}]}";
                if (msg.entityid != -1000 && (entity = sender.f_19853_.m_6815_(msg.entityid)) instanceof NpcEntity) {
                    NpcEntity npcEntity = (NpcEntity)entity;
                    for (String name : CommonDialogueUtil.HELLO_THERE_NAMES) {
                        if (!npcEntity.m_7755_().getString().equalsIgnoreCase(name)) continue;
                        dialogueJson = "{\"name\":\"init\",\"text\":\"Hello there!\",\"children\":[{\"name\":\"generalKenobi\",\"text\":\"General Kenobi! You are a bold one. I'll deal with you Jedi slime myself.\",\"response\":\"Your move.\",\"children\":[{\"name\":\"youFool\",\"text\":\"You fool. I've been trained in your Jedi arts by Count Dooku.\",\"response\":\"[draws lightsaber]\"}]}]}";
                        break;
                    }
                    if (npcEntity.m_7755_().getString().equalsIgnoreCase("Dick Kickem")) {
                        dialogueJson = "{\"name\":\"init\",\"text\":\"It's Time To Kick Gum and Chew Ass. And I'm All Out Of Ass.\",\"children\":[]}";
                    }
                }
                CommonDialogueUtil.buildDialogue(msg.name, dialogueJson);
                PacketDispatcher.sendTo(new SSendDialogue(msg.name, dialogueJson), (Player)sender);
            }
            if (msg.entityid != -1000) {
                PacketDispatcher.sendTo(new SOpenScreen(SOpenScreen.EScreens.DIALOGUE, msg.name, msg.entityid), (Player)sender);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

