/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import com.google.gson.JsonObject;
import flash.npcmod.core.PermissionHelper;
import flash.npcmod.core.dialogues.CommonDialogueUtil;
import flash.npcmod.core.functions.AbstractFunction;
import flash.npcmod.core.functions.FunctionUtil;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.server.SOpenScreen;
import flash.npcmod.network.packets.server.SResetFunctionNames;
import flash.npcmod.network.packets.server.SSendDialogueEditor;
import flash.npcmod.network.packets.server.SSendFunctionName;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CRequestDialogueEditor {
    String name;
    int entityid;

    public CRequestDialogueEditor(String name) {
        this(name, -1000);
    }

    public CRequestDialogueEditor(String name, int entityid) {
        this.name = name;
        this.entityid = entityid;
    }

    public static void encode(CRequestDialogueEditor msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.name);
        buf.writeInt(msg.entityid);
    }

    public static CRequestDialogueEditor decode(FriendlyByteBuf buf) {
        return new CRequestDialogueEditor(buf.m_130136_(100000), buf.readInt());
    }

    public static void handle(CRequestDialogueEditor msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (PermissionHelper.hasPermission((Player)sender, PermissionHelper.EDIT_DIALOGUE)) {
                ArrayList<String> functionNames = new ArrayList<String>();
                for (AbstractFunction function : FunctionUtil.FUNCTIONS) {
                    StringBuilder name = new StringBuilder(function.getName());
                    String[] paramNames = function.getParamNames();
                    if (paramNames.length > 0 && !paramNames[0].isEmpty()) {
                        name.append("::");
                        for (String paramName : paramNames) {
                            name.append(paramName).append(",");
                        }
                        name = new StringBuilder(name.substring(0, name.length() - 1));
                    }
                    functionNames.add(name.toString());
                }
                PacketDispatcher.sendTo(new SResetFunctionNames(), (Player)sender);
                for (String name : functionNames) {
                    PacketDispatcher.sendTo(new SSendFunctionName(name), (Player)sender);
                }
                JsonObject dialogue = CommonDialogueUtil.loadDialogueEditorFile(msg.name);
                if (dialogue != null) {
                    PacketDispatcher.sendTo(new SSendDialogueEditor(msg.name, dialogue.toString()), (Player)sender);
                } else {
                    Entity entity;
                    String dialogueEditorJson = "{\"entries\":[{\"name\":\"init\",\"x\":10,\"y\":10},{\"name\":\"hello\",\"x\":150,\"y\":10}]}";
                    if (msg.entityid != -1000 && (entity = sender.f_19853_.m_6815_(msg.entityid)) instanceof NpcEntity) {
                        NpcEntity npcEntity = (NpcEntity)entity;
                        for (String name : CommonDialogueUtil.HELLO_THERE_NAMES) {
                            if (!npcEntity.m_7755_().getString().equalsIgnoreCase(name)) continue;
                            dialogueEditorJson = "{\"entries\":[{\"name\":\"init\",\"x\":10,\"y\":10},{\"name\":\"generalKenobi\",\"x\":150,\"y\":10},{\"name\":\"youFool\",\"x\":300,\"y\":10}]}";
                            break;
                        }
                        if (npcEntity.m_7755_().getString().equalsIgnoreCase("Dick Kickem")) {
                            dialogueEditorJson = "{\"entries\":[{\"name\":\"init\",\"x\":10,\"y\":10}]}";
                        }
                    }
                    CommonDialogueUtil.buildDialogueEditor(msg.name, dialogueEditorJson);
                    PacketDispatcher.sendTo(new SSendDialogueEditor(msg.name, dialogueEditorJson), (Player)sender);
                }
                if (msg.entityid != -1000) {
                    PacketDispatcher.sendTo(new SOpenScreen(SOpenScreen.EScreens.EDITDIALOGUE, msg.name, msg.entityid), (Player)sender);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

