/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.client;

import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.server.SSyncQuestCapability;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CTrackQuest {
    String name;

    public CTrackQuest(QuestInstance questInstance) {
        this(questInstance.getQuest().getName());
    }

    public CTrackQuest(String name) {
        this.name = name;
    }

    public static void encode(CTrackQuest msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.name);
    }

    public static CTrackQuest decode(FriendlyByteBuf buf) {
        return new CTrackQuest(buf.m_130136_(51));
    }

    public static void handle(CTrackQuest msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)sender);
            if (!msg.name.isEmpty() && !capability.getTrackedQuest().equals(msg.name)) {
                ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
                for (QuestInstance questInstance : acceptedQuests) {
                    if (!questInstance.getQuest().getName().equals(msg.name)) continue;
                    capability.setTrackedQuest(msg.name);
                    break;
                }
            } else {
                capability.setTrackedQuest("");
            }
            PacketDispatcher.sendTo(new SSyncQuestCapability(capability.getTrackedQuest()), (Player)sender);
        });
        ctx.get().setPacketHandled(true);
    }
}

