/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.server;

import flash.npcmod.Main;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SSyncSavedNpcs {
    List<String> savedNpcs;
    boolean isGlobal;

    public SSyncSavedNpcs(List<String> savedNpcs, boolean isGlobal) {
        this.savedNpcs = savedNpcs;
        this.isGlobal = isGlobal;
    }

    public static void encode(SSyncSavedNpcs msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.savedNpcs.size());
        for (String s : msg.savedNpcs) {
            buf.m_130072_(s, Short.MAX_VALUE);
        }
        buf.writeBoolean(msg.isGlobal);
    }

    public static SSyncSavedNpcs decode(FriendlyByteBuf buf) {
        ArrayList<String> savedNpcs = new ArrayList<String>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            savedNpcs.add(buf.m_130277_());
        }
        boolean isGlobal = buf.readBoolean();
        return new SSyncSavedNpcs(savedNpcs, isGlobal);
    }

    public static void handle(SSyncSavedNpcs msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Main.PROXY.loadSavedNpcs(msg.savedNpcs, msg.isGlobal));
        ctx.get().setPacketHandled(true);
    }
}

