/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.network.packets.server;

import flash.npcmod.Main;
import flash.npcmod.core.trades.TradeOffer;
import flash.npcmod.core.trades.TradeOffers;
import flash.npcmod.entity.NpcEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SSyncTrades {
    int entityid;
    TradeOffers tradeOffers;

    public SSyncTrades(NpcEntity npcEntity) {
        this(npcEntity.m_142049_(), npcEntity.getOffers());
    }

    public SSyncTrades(int entityid, TradeOffers tradeOffers) {
        this.entityid = entityid;
        this.tradeOffers = tradeOffers;
    }

    public static void encode(SSyncTrades msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityid);
        buf.writeInt(msg.tradeOffers.size());
        for (TradeOffer tradeOffer : msg.tradeOffers) {
            buf.m_130055_(tradeOffer.getBuyingStacks()[0]);
            buf.m_130055_(tradeOffer.getBuyingStacks()[1]);
            buf.m_130055_(tradeOffer.getBuyingStacks()[2]);
            buf.m_130055_(tradeOffer.getSellingStacks()[0]);
            buf.m_130055_(tradeOffer.getSellingStacks()[1]);
            buf.m_130055_(tradeOffer.getSellingStacks()[2]);
        }
    }

    public static SSyncTrades decode(FriendlyByteBuf buf) {
        int entityid = buf.readInt();
        int tradeOffersSize = buf.readInt();
        TradeOffers tradeOffers = new TradeOffers();
        for (int i = 0; i < tradeOffersSize; ++i) {
            tradeOffers.add(new TradeOffer(buf.m_130267_(), buf.m_130267_(), buf.m_130267_(), buf.m_130267_(), buf.m_130267_(), buf.m_130267_()));
        }
        return new SSyncTrades(entityid, tradeOffers);
    }

    public static void handle(SSyncTrades msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Main.PROXY.syncTrades(msg.entityid, msg.tradeOffers));
        ctx.get().setPacketHandled(true);
    }
}

