/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.regions_unexplored.client.particle.RegionsUnexploredParticleTypes;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuBiomePlacements;
import net.regions_unexplored.data.worldgen.placement.RuPlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class RuOverworldBiomes {
    @Nullable
    private static final Music NORMAL_MUSIC = null;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)builder);
    }

    public static Biome scorch() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-6384241).m_48034_(-10129331).m_48037_(-10989767).m_48040_(-9146774).m_48043_(-8949914).m_48045_(-8621472).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.1f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.FLUID_SPRINGS, RuPlacements.OVERWORLD_LAVA_DELTA);
        biomeBuilder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, RuPlacements.BASALT_BLOB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, RuPlacements.ASH_VENT);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SCORCH_TREES);
        biomeBuilder.m_204201_(GenerationStep.Decoration.FLUID_SPRINGS, RuPlacements.LAVA_FALL);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.UNDERGROUND).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome lushDelta() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-13369345).m_48037_(329011).m_48040_(7972607).m_48043_(-10118056).m_48045_(-9658528).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 5, 1, 5));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUSH_DELTA_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUSH_DELTA_TALL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUSH_DELTA_YELLOW_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUSH_DELTA_PINK_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUSH_DELTA_TREES);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.addSpringVegetation(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.UNDERGROUND).m_47609_(1.125f).m_47611_(0.8f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome redstoneCaves() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-12619852).m_48037_(-14007447).m_48040_(7972607).m_48043_(-16737793).m_48045_(-6625354).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.pointedRedstone(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.UNDERGROUND).m_47609_(0.8f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome prismachasm() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-14772238).m_48037_(-15959346).m_48040_(-13068579).m_48043_(-16737793).m_48045_(-6625354).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123815_, 0.002f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PRISMACHASM_SPROUT);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PRISMACHASM_CRYSTAL);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PRISMACHASM_HYSSOP);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuPlacements.HANGING_PRISMARITE_CLUSTER);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.UNDERGROUND).m_47609_(0.925f).m_47611_(0.9f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome bioshroomCaves() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48040_(7972607).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48045_(-11093361).m_48043_(-11093410).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_175833_, 0.01f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_11653_((SoundEvent)SoundEvents.f_184222_)).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.AXOLOTLS, new MobSpawnSettings.SpawnerData(EntityType.f_147039_, 10, 4, 6));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 8, 8));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BIOSHROOM_CAVES_GIANT_GREEN_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BIOSHROOM_CAVES_GIANT_BLUE_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BIOSHROOM_CAVES_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BIOSHROOM_CAVES_TALL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BIOSHROOM_CAVES_GREEN_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BIOSHROOM_CAVES_BLUE_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BIOSHROOM_CAVES_PINK_BIOSHROOM);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(1.25f).m_47595_(Biome.BiomeCategory.UNDERGROUND).m_47611_(0.9f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome pineSlopes() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-12619852).m_48037_(-14007447).m_48040_(7972607).m_48043_(-9075130).m_48045_(-8083622).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PINE_SLOPES_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PINE_SLOPES_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PINE_SLOPES_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PINE_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addForestFernsOnDirt(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.MOUNTAIN).m_47609_(0.375f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome mountains() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-12619852).m_48037_(-14007447).m_48040_(7972607).m_48043_(-9075130).m_48045_(-8083622).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 5, 1, 3));
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MOUNTAINS_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MOUNTAINS_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MOUNTAINS_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MOUNTAINS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PINE_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PATCH_FOREST_FERNS);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.MOUNTAIN).m_47609_(0.28f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome highlandFields() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(-1635927829).m_48043_(-8275350).m_48045_(-9782677).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20466_, 5, 4, 6));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.noiseBush(biomeBuilder);
        RuBiomeDefaultFeatures.noiseRocks(biomeBuilder);
        RuBiomeDefaultFeatures.addDaisies(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(0.65f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome lushHills() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-10566460).m_48037_(-12229487).m_48040_(-1635927829).m_48043_(-8010658).m_48045_(-7493535).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20466_, 5, 4, 6));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUSH_HILLS_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUSH_HILLS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_OAK_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.EXTREME_HILLS).m_47609_(0.775f).m_47611_(0.55f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome muddyRiver() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-7159980).m_48045_(-6044317).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder().m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 2, 1, 4)).m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20562_, 100, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MUDDY_RIVER_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MUDDY_RIVER_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_OAK_SAPLING);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRiverCattail(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, RuPlacements.RU_MUD_BIG);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addSeagrass(biomeBuilder);
        BiomeDefaultFeatures.m_126763_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.RIVER).m_47609_(0.75f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome coldRiver() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-5718172).m_48045_(-4733087).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder().m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 2, 1, 4)).m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20562_, 100, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_MAPLE_SAPLING);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRiverCattail(biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addSeagrass(biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.RIVER).m_47609_(0.4f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome grassyBeach() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8933043).m_48045_(-2697863).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GRASSY_BEACH_SANDY_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GRASSY_BEACH_SANDY_TALL_GRASS);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        RuBiomeDefaultFeatures.addSeagrass(biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.BEACH).m_47609_(0.85f).m_47611_(0.775f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome gravelBeach() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8673714).m_48045_(-7819420).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.BEACH).m_47609_(0.6f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome mapleForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(6462505).m_48045_(9550928).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAPLE_FOREST_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAPLE_FOREST_RED_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAPLE_FOREST_BIG_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAPLE_FOREST_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_MAPLE_SAPLING_MIX);
        RuBiomeDefaultFeatures.mapleForestVegetation(biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.6f).m_47611_(0.5f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome fen() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-11629645).m_48037_(-12884349).m_48040_(7972607).m_48043_(8754506).m_48045_(10858333).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder().m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FEN_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FEN_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FEN_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FEN_DEAD_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FEN_DEAD_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FEN_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FEN_CATTAILS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PINE_DEAD_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addMuddyDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addDuckweed(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.SWAMP).m_47609_(0.85f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome blackwoodForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-5322337).m_48034_(-13668958).m_48037_(-12557181).m_48040_(-5322337).m_48043_(-12430037).m_48045_(-12687577).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.005f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder().m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 5, 1, 5));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 8, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BLACKWOOD_FOREST_TALL_BLACKWOOD);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BLACKWOOD_FOREST_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BLACKWOOD_FOREST_BLACKWOOD);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BLACKWOOD_FOREST_MUSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BLACKWOOD_FOREST_DARK_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BLACKWOOD_FOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BLACKWOOD_FOREST_TALL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BLACKWOOD_FOREST_PINK_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BLACKWOOD_FOREST_BLUE_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_BLACKWOOD_DARK_OAK_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.TAIGA).m_47609_(0.825f).m_47611_(0.765f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome flowerField() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-10635453).m_48045_(-9189045).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 8, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_YELLOW_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_RED_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_PINK_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_PURPLE_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_BLUE_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_POPPY_PATCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_HYSSOP);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_WARATAH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_TRILLIUM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_TSUBAKI);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_FIREWEED);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_DAISY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_FELICIA_DAISY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_TASSEL);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_POPPIES);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_BLUE_ORCHIDS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_ALLIUM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_RED_TULIP);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_ORANGE_TULIP);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_PINK_TULIP);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_WHITE_TULIP);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_OXEYE_DAISY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_CORNFLOWER);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_LILLIES);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_SUNFLOWER);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_GREEN_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOWER_FIELD_BLUE_BIOSHROOM);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(0.975f).m_47611_(0.8f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome grassland() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-7159980).m_48045_(-6044317).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GRASSLAND_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GRASSLAND_GRASS);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addGrasslandTallGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(0.85f).m_47611_(0.45f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome baobabSavanna() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-6636971).m_48045_(-4670891).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAOBAB_SAVANNA_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAOBAB_SAVANNA_BIG_BAOBAB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAOBAB_SAVANNA_SMALL_BAOBAB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAOBAB_SAVANNA_ACACIA);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAOBAB_SAVANNA_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAOBAB_SAVANNA_STONE_BUD);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAOBAB_SAVANNA_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAOBAB_SAVANNA_TALL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_BAOBAB_SAPLING);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.SAVANNA).m_47609_(2.0f).m_47611_(0.35f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome shrubland() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8999081).m_48045_(-6637733).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SHRUBLAND_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SHRUBLAND_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SHRUBLAND_SPRUCE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SHRUBLAND_OAK_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SHRUBLAND_SPRUCE_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SHRUBLAND_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SHRUBLAND_YELLOW_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SHRUBLAND_RED_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PINE_SPRUCE_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addGrasslandTallGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(0.575f).m_47611_(0.4f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome icyHeights() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(-3411969).m_48043_(-9913745).m_48045_(-9059189).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 5, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ICY_HEIGHTS_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ICY_HEIGHTS_DEAD_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ICY_HEIGHTS_SNOWY_GRASS);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.ICY).m_47609_(-1.0f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome oldGrowthRainforest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-13392941).m_48037_(-11558718).m_48040_(7972607).m_48043_(-11032271).m_48045_(-9718455).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OLD_GROWTH_RAINFOREST_PALM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OLD_GROWTH_RAINFOREST_JUNGLE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OLD_GROWTH_RAINFOREST_BIG_JUNGLE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OLD_GROWTH_RAINFOREST_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OLD_GROWTH_RAINFOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OLD_GROWTH_RAINFOREST_GREEN_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OLD_GROWTH_RAINFOREST_BLUE_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OLD_GROWTH_RAINFOREST_ELEPHANT_EAR);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PALM_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addForestFernsOnDirt(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_198929_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.JUNGLE).m_47609_(1.0f).m_47611_(1.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome rainforest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-13392941).m_48037_(-11558718).m_48040_(7972607).m_48043_(-11032271).m_48045_(-9718455).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.RAINFOREST_PALM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.RAINFOREST_JUNGLE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.RAINFOREST_BIG_JUNGLE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.RAINFOREST_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.RAINFOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.RAINFOREST_GREEN_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.RAINFOREST_PINK_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.RAINFOREST_ELEPHANT_EAR);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PALM_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addForestFernsOnDirt(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_198929_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.JUNGLE).m_47609_(1.0f).m_47611_(0.95f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome tropics() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-13255466).m_48037_(-11171160).m_48040_(-1635927829).m_48043_(-11617740).m_48045_(-11225797).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 3));
        spawnBuilder.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 2, 1, 4)).m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 5, 1, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_PALM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_JUNGLE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_BIG_JUNGLE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_PINK_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_RED_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_FELICIA_DAISY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_ELEPHANT_EAR);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_SANDY_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TROPICS_SANDY_TALL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PALM_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addForestFernsOnDirt(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addSeagrass(biomeBuilder);
        BiomeDefaultFeatures.m_126763_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.JUNGLE).m_47609_(1.05f).m_47611_(0.95f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome pumpkinFields() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48040_(7972607).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(9877306).m_48045_(11585358).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_FIELDS_RED_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_FIELDS_ORANGE_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_FIELDS_DEAD_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_FIELDS_SILVER_BIRCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_FIELDS_BIG_RED_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_FIELDS_BIG_ORANGE_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_FIELDS_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_FIELDS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_AUTUMNAL_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addForestFernsOnDirt(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.noisePumpkins(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.225f).m_47595_(Biome.BiomeCategory.PLAINS).m_47611_(0.3f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome autumnalMapleForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48040_(7972607).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(9877306).m_48045_(12896058).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_MAPLE_FOREST_RED_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_MAPLE_FOREST_ORANGE_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_MAPLE_FOREST_MAPLE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_MAPLE_FOREST_SILVER_BIRCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_MAPLE_FOREST_BIG_RED_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_MAPLE_FOREST_BIG_ORANGE_MAPLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.AUTUMNAL_MAPLE_FOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_AUTUMNAL_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.225f).m_47595_(Biome.BiomeCategory.FOREST).m_47611_(0.3f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome mixedForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8999072).m_48045_(-8739993).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.WILLOW_FOREST_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.WILLOW_FOREST_WHITE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.WILLOW_FOREST_WILLOW);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.WILLOW_FOREST_SPRUCE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.WILLOW_FOREST_DEAD_SPRUCE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.WILLOW_FOREST_BIG_WILLOW);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.WILLOW_FOREST_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.WILLOW_FOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_WILLOW_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addPinkFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.6f).m_47611_(0.5f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome coldBorealForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-9922472).m_48045_(-9917084).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_GOLDEN_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_BIRCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_SMALL_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_FERN);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_LARCH_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.ICY).m_47609_(0.0f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome borealForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-12619852).m_48037_(-14007447).m_48040_(7972607).m_48043_(-8673714).m_48045_(-7819420).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_GOLDEN_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_BIRCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_SMALL_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_FERN);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BOREAL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_LARCH_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.TAIGA).m_47609_(0.5f).m_47611_(0.4f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome chalkCliffs() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8414642).m_48045_(-6044317).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHALK_CLIFFS_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHALK_CLIFFS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_FLOWERING_SAPLING);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.BEACH).m_47609_(0.775f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome lupinePlains() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-6044317).m_48045_(-6044317).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUPINE_PLAINS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUPINE_PLAINS_YELLOW_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUPINE_PLAINS_RED_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUPINE_PLAINS_BLUE_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUPINE_PLAINS_PURPLE_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUPINE_PLAINS_PINK_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.LUPINE_PLAINS_STONE_BUD);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(1.35f).m_47611_(0.25f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome steppe() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-5589135).m_48045_(-5067675).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.STEPPE_PLAINS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.STEPPE_PLAINS_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.STEPPE_PLAINS_TALL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.STEPPE_PLAINS_DEAD_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.STEPPE_PLAINS_DESERT_SHRUB);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.SAVANNA).m_47609_(1.5f).m_47611_(0.25f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome aridMountains() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-6773446).m_48045_(-4279222).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ARID_MOUNTAINS_STONE_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ARID_MOUNTAINS_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ARID_MOUNTAINS_ACACIA_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ARID_MOUNTAINS_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ARID_MOUNTAINS_ACACIA);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ARID_MOUNTAINS_STONE_BUD);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_ACACIA_SAPLING);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126816_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126751_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126755_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.MOUNTAIN).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome joshuaDesert() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8409523).m_48045_(-5213).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.JOSHUA_DESERT_LARGE_JOSHUA_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.JOSHUA_DESERT_MEDIUM_JOSHUA_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.JOSHUA_DESERT_DEAD_STEPPE_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.JOSHUA_DESERT_DESERT_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.JOSHUA_DESERT_SANDY_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_JOSHUA_SAPLING);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126751_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126755_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.DESERT).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome prairie() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8933043).m_48045_(-2697863).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PRAIRIE_BIG_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PRAIRIE_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PRAIRIE_BARLEY);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addSeededGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(0.75f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome barleyFields() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-5256873).m_48045_(-5754).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BARLEY_FIELDS_BARLEY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BARLEY_FIELDS_GRASS);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(0.85f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome goldenBorealForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-4214704).m_48045_(-6376609).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GOLDEN_BOREAL_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GOLDEN_BOREAL_GOLDEN_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GOLDEN_BOREAL_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GOLDEN_BOREAL_BIRCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GOLDEN_BOREAL_SMALL_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GOLDEN_BOREAL_FERN);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GOLDEN_BOREAL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_GOLDEN_LARCH_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.TAIGA).m_47609_(0.45f).m_47611_(0.3f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome alphaGrove() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-14919459).m_48037_(-12292142).m_48040_(7972607).m_48043_(-10749125).m_48045_(-7876009).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ALPHA_GROVE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ALPHA_GROVE_ROSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ALPHA_GROVE_DANDELION);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.0f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome silverBirchForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48040_(7972607).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(11585338).m_48045_(11585338).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SILVER_BIRCH_FOREST_ASPEN);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SILVER_BIRCH_FOREST_SILVER_BIRCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SILVER_BIRCH_FOREST_BIRCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SILVER_BIRCH_FOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SILVER_BIRCH_FOREST_SEEDED_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SILVER_BIRCH_FOREST_TASSEL);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_BIRCH_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.6f).m_47595_(Biome.BiomeCategory.FOREST).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome deciduousForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-7491753).m_48045_(-7491753).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DECIDUOUS_FOREST_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DECIDUOUS_FOREST_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DECIDUOUS_FOREST_BIG_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_OAK_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addForestFernsOnDirt(biomeBuilder);
        RuBiomeDefaultFeatures.addSeededGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.75f).m_47611_(0.8f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome orchard() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-6108056).m_48045_(-5059481).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 8, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ORCHARD_APPLE_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ORCHARD_BIG_APPLE_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ORCHARD_BIG_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ORCHARD_TASSEL);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ORCHARD_DAISY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ORCHARD_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_OAK_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.7f).m_47611_(0.4f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome redwoodForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-9264584).m_48045_(-8537031).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.REDWOODS_GIANT_REDWOOD);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.REDWOODS_REDWOOD);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.REDWOODS_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.REDWOODS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_REDWOOD_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addForestFernsOnDirt(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.TAIGA).m_47609_(1.0f).m_47611_(0.8f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome sparseRedwoods() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-9264584).m_48045_(-8537031).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SPARSE_REDWOODS_REDWOOD);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SPARSE_REDWOODS_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SPARSE_REDWOODS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_REDWOOD_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.TAIGA).m_47609_(0.95f).m_47611_(0.8f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome giantBayou() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-5124939).m_48034_(-12354486).m_48037_(-10450614).m_48040_(-6110795).m_48043_(-9333940).m_48045_(-8609196).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.01f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 1, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_BIG_CYPRESS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_BIG_CYPRESS_MOSS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_OAK_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_BIG_WILLOW);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_TALL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_ELEPHANT_EAR);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.GIANT_BAYOU_FERN);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_CYPRESS_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.addWaterLake(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, RuPlacements.RU_MUD_BIG);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195417_);
        RuBiomeDefaultFeatures.addSeagrass(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addBayouCattail(biomeBuilder);
        RuBiomeDefaultFeatures.addSparseLily(biomeBuilder);
        RuBiomeDefaultFeatures.addMuddyMarsh(biomeBuilder);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.SWAMP).m_47609_(1.0f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome bayou() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-1350062718).m_48034_(-12354486).m_48037_(-10450614).m_48040_(-1350062718).m_48043_(-9333940).m_48045_(-8609196).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.01f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 1, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_WILLOW);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_MOSSY_CYPRESS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_CYPRESS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_BIG_CYPRESS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_BIG_MOSSY_CYPRESS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_ELEPHANT_EAR);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAYOU_FERN);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_WILLOW_CYPRESS_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, RuPlacements.RU_MUD_BIG);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195417_);
        RuBiomeDefaultFeatures.addSeagrass(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addBayouCattail(biomeBuilder);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.SWAMP).m_47609_(0.95f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome bambooForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-5124939).m_48034_(4159204).m_48037_(329011).m_48040_(-6110795).m_48043_(-5636253).m_48045_(-4923788).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20507_, 80, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAMBOO_FOREST_GIANT_BAMBOO);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAMBOO_FOREST_TSUBAKI);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAMBOO_FOREST_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.BAMBOO_FOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_CHERRY_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        RuBiomeDefaultFeatures.addRuBamboo(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_198929_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.875f).m_47611_(0.8f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome poppyFields() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8414642).m_48045_(-6044317).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.POPPY_FIELDS_POPPY_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.POPPY_FIELDS_POPPY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.POPPY_FIELDS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_RED_MAPLE_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(0.85f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome pineForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-9075130).m_48045_(-8083622).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PINE_FOREST_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PINE_FOREST_TALL_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PINE_FOREST_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PINE_FOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.PINE_FOREST_TALL_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PINE_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.addForestFernsOnDirt(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.TAIGA).m_47609_(0.6f).m_47611_(0.4f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome cherryHills() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8929686).m_48045_(-9781654).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_CHERRY_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_BIG_CHERRY_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_RED_CHERRY_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_RED_BIG_CHERRY_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_PINK_CHERRY_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_PINK_BIG_CHERRY_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_WHITE_CHERRY_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_WHITE_BIG_CHERRY_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.CHERRY_HILLS_TSUBAKI);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_CHERRY_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addPinkFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.95f).m_47611_(0.8f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome temperateGrove() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-6705587).m_48045_(-7953067).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TEMPERATE_GROVE_MAPLE_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TEMPERATE_GROVE_BIRCH_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TEMPERATE_GROVE_OAK_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TEMPERATE_GROVE_LARCH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TEMPERATE_GROVE_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TEMPERATE_GROVE_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TEMPERATE_GROVE_TASSEL);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TEMPERATE_GROVE_DAISY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_FLOWERING_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.775f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome eucalyptusForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-9651647).m_48045_(-9651647).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.EUCALYPTUS_FOREST_EUCALYPTUS_TREE_CANOPY);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.EUCALYPTUS_FOREST_EUCALYPTUS_TREE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.EUCALYPTUS_FOREST_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.EUCALYPTUS_FOREST_SAPLING);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.EUCALYPTUS_FOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.EUCALYPTUS_FOREST_ELEPHANT_EAR);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.EUCALYPTUS_FOREST_WARATAH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_EUCALYPTUS_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_198929_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.JUNGLE).m_47609_(1.15f).m_47611_(0.85f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome mauveHills() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-11230855).m_48037_(329011).m_48040_(7972607).m_48043_(-12810288).m_48045_(-9259116).m_48029_(new AmbientParticleSettings((ParticleOptions)((SimpleParticleType)RegionsUnexploredParticleTypes.MAUVE.get()), 0.005f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAUVE_HILLS_MAUVE_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAUVE_HILLS_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAUVE_HILLS_BIG_MAUVE_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAUVE_HILLS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAUVE_HILLS_PURPLE_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAUVE_HILLS_PINK_LUPINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MAUVE_HILLS_PINK_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_MAUVE_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addPinkFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(1.1f).m_47611_(0.85f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome toweringCliffs() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-7362208).m_48045_(-8482734).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 5, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TOWERING_CLIFFS_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TOWERING_CLIFFS_DEAD_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TOWERING_CLIFFS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TOWERING_CLIFFS_HYSSOP);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.TOWERING_CLIFFS_FERNS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PINE_DEAD_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.EXTREME_HILLS).m_47609_(0.335f).m_47611_(0.65f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome fungalFen() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-435307641).m_48037_(-435242116).m_48040_(-427965270).m_48043_(-433341681).m_48045_(-430585537).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123785_, 0.01f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20504_, 8, 4, 8));
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FUNGAL_FEN_BROWN_MUSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FUNGAL_FEN_RED_MUSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FUNGAL_FEN_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FUNGAL_FEN_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FUNGAL_FEN_ELEPHANT_EAR);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FUNGAL_FEN_FERN);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FUNGAL_FEN_GREEN_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FUNGAL_FEN_BLUE_BIOSHROOM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_PINE_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_198931_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.SWAMP).m_47609_(0.975f).m_47611_(0.9f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome outback() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-8016810).m_48045_(-4670891).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OUTBACK_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OUTBACK_SHRUB_DENSE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OUTBACK_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OUTBACK_DEAD_STEPPE_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OUTBACK_DESERT_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.OUTBACK_STONE_BUD);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        RuBiomeDefaultFeatures.addOutbackExtraVegetation(biomeBuilder);
        BiomeDefaultFeatures.m_126755_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.DESERT).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome saguaroDesert() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-6836695).m_48045_(-4212907).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SAGUARO_DESERT_CACTUS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SAGUARO_DESERT_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SAGUARO_DESERT_SANDY_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SAGUARO_DESERT_BARREL_CACTUS);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addQuicksand(biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195401_);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195450_);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PATCH_CACTUS_OUTBACK);
        BiomeDefaultFeatures.m_126755_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.DESERT).m_47609_(1.75f).m_47611_(0.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome frozenTundra() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-5207984).m_48045_(-5215920).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20514_, 8, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FROZEN_TUNDRA_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FROZEN_TUNDRA_MAPLE_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FROZEN_TUNDRA_SHRUB_SNOW);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FROZEN_TUNDRA_MAPLE_SHRUB_SNOW);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FROZEN_TUNDRA_SNOWY_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FROZEN_TUNDRA_GRASS);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.noiseAutumnBush(biomeBuilder);
        RuBiomeDefaultFeatures.noiseRocks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.ICY).m_47609_(-1.0f).m_47611_(0.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome dryBushland() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-5060484).m_48045_(-3552115).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DRY_BRUSHLAND_ACACIA);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DRY_BRUSHLAND_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DRY_BRUSHLAND_JOSHUA_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DRY_BRUSHLAND_SHRUB_SAND);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DRY_BRUSHLAND_JOSHUA_SHRUB_SAND);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DRY_BRUSHLAND_SANDY_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DRY_BRUSHLAND_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DRY_BRUSHLAND_DESERT_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.DRY_BRUSHLAND_FIREWEED);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_ACACIA_SAPLING);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195401_);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195450_);
        BiomeDefaultFeatures.m_126755_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.SAVANNA).m_47609_(1.5f).m_47611_(0.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome coldDeciduousForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-5718172).m_48045_(-4733087).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 12, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.COLD_DECIDUOUS_FOREST_BUSH);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.COLD_DECIDUOUS_FOREST_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.COLD_DECIDUOUS_FOREST_BIG_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.COLD_DECIDUOUS_FOREST_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_RED_MAPLE_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.ICY).m_47609_(0.0f).m_47611_(0.45f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome icyDesert() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(-3411969).m_48043_(-10247846).m_48045_(-10247846).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20514_, 8, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ICY_DESERT_STONE_BUD);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.ICY_DESERT_SNOWY_GRASS);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.ICY).m_47609_(-2.0f).m_47611_(0.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome spires() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(-3411969).m_48043_(-11097502).m_48045_(-11097488).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20514_, 8, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SPIRES_SNOWY_GRASS);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.ICY).m_47609_(-2.0f).m_47611_(0.95f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome smoulderingWoodland() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-6384241).m_48034_(-10073800).m_48037_(-11585236).m_48040_(-5400196).m_48043_(-7901343).m_48045_(-6391454).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123783_, 0.05f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 100, 4, 4));
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, RuPlacements.ASH_VENT_SURFACE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SMOULDERING_WOODLAND_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SMOULDERING_WOODLAND_DEAD_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SMOULDERING_WOODLAND_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SMOULDERING_WOODLAND_DORCEL);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SMOULDERING_WOODLAND_TRILLIUM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SMOULDERING_WOODLAND_DEAD_STEPPE_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.SMOULDERING_WOODLAND_DESERT_SHRUB);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_DEAD_SAPLING_MIX);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome frozenForest() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(4159204).m_48040_(-3411969).m_48043_(-9922472).m_48045_(-9917084).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FROZEN_FOREST_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FROZEN_FOREST_TALL_PINE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FROZEN_FOREST_SNOWY_GRASS);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.noiseRocks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.ICY).m_47609_(-0.5f).m_47611_(0.6f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome meadow() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48043_(-9001891).m_48045_(-7486095).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MEADOW_MAUVE_OAK_BEE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MEADOW_MAUVE_OAK);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.MEADOW_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_MAUVE_SAPLING);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        RuBiomeDefaultFeatures.meadowFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addRuDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addPinkFlowers(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(0.825f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome floodedPlains() {
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(-12092489).m_48037_(-13677218).m_48040_(7972607).m_48043_(-8339092).m_48045_(-8536223).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_();
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder().m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOODED_PLAINS_GRASS);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, RuBiomePlacements.FLOODED_PLAINS_TALL_GRASS);
        RuOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addMuddyDisks(biomeBuilder);
        RuBiomeDefaultFeatures.addSparseDuckweed(biomeBuilder);
        RuBiomeDefaultFeatures.addRuFlowers(biomeBuilder);
        RuBiomeDefaultFeatures.addMarsh(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.SWAMP).m_47609_(0.85f).m_47611_(0.7f).m_47603_(effects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }
}

