/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.regions_unexplored.data.worldgen.features.feature.AshVentFeature;
import net.regions_unexplored.data.worldgen.features.feature.BasaltBlobFeature;
import net.regions_unexplored.data.worldgen.features.feature.GlisteringIvyFeature;
import net.regions_unexplored.data.worldgen.features.feature.HangingEarlightFeature;
import net.regions_unexplored.data.worldgen.features.feature.HangingPrismariteFeature;
import net.regions_unexplored.data.worldgen.features.feature.LavaDeltaFeature;
import net.regions_unexplored.data.worldgen.features.feature.LavaFallFeature;
import net.regions_unexplored.data.worldgen.features.feature.NetherBlockBlobFeature;
import net.regions_unexplored.data.worldgen.features.feature.ObsidianSpireFeature;
import net.regions_unexplored.data.worldgen.features.feature.RockPillarFeature;
import net.regions_unexplored.data.worldgen.features.feature.WaterCattailFeature;
import net.regions_unexplored.data.worldgen.features.feature.bioshroom.GiantBioshroomConfiguration;
import net.regions_unexplored.data.worldgen.features.feature.bioshroom.GiantBlueBioshroomFeature;
import net.regions_unexplored.data.worldgen.features.feature.bioshroom.GiantGreenBioshroomFeature;
import net.regions_unexplored.data.worldgen.features.feature.bioshroom.PinkBioshroomFeature;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.LargePointedRedstoneConfiguration;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.LargePointedRedstoneFeature;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneClusterConfiguration;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneClusterFeature;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneConfiguration;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneFeature;
import net.regions_unexplored.data.worldgen.features.feature.tree.LargeJoshuaTreeFeature;
import net.regions_unexplored.data.worldgen.features.feature.tree.MapleTreeFeature;
import net.regions_unexplored.data.worldgen.features.feature.tree.MediumJoshuaTreeFeature;
import net.regions_unexplored.data.worldgen.features.feature.tree.TallSaplingFeature;
import net.regions_unexplored.data.worldgen.features.feature.tree.config.RuTreeConfiguration;
import net.regions_unexplored.data.worldgen.features.feature.tree.config.TallSaplingConfiguration;
import net.regions_unexplored.data.worldgen.features.treefeature.GiantSculkWillowFeature;
import net.regions_unexplored.data.worldgen.features.treefeature.NetherWillowFeature;
import net.regions_unexplored.data.worldgen.features.treefeature.SculkWillowFeature;
import net.regions_unexplored.data.worldgen.structures.MeadowRock;
import net.regions_unexplored.data.worldgen.structures.Spires;

@Mod.EventBusSubscriber
public class RuFeatureRegistry {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"regions_unexplored");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> ICE_SPIRES = RuFeatureRegistry.registerStructure("ice_spires", Spires::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Spires.GENERATE_BIOMES, Spires::placedFeature));
    public static final RegistryObject<Feature<?>> MEADOW_ROCKS = RuFeatureRegistry.registerStructure("meadow_rocks", MeadowRock::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, MeadowRock.GENERATE_BIOMES, MeadowRock::placedFeature));
    public static final Feature<GiantBioshroomConfiguration> GIANT_GREEN_BIOSHROOM = RuFeatureRegistry.register("giant_green_bioshroom", new GiantGreenBioshroomFeature(GiantBioshroomConfiguration.CODEC));
    public static final Feature<GiantBioshroomConfiguration> GIANT_BLUE_BIOSHROOM = RuFeatureRegistry.register("giant_blue_bioshroom", new GiantBlueBioshroomFeature(GiantBioshroomConfiguration.CODEC));
    public static final Feature<RuTreeConfiguration> MAPLE_TREE = RuFeatureRegistry.register("maple_tree", new MapleTreeFeature(RuTreeConfiguration.CODEC));
    public static final Feature<NoneFeatureConfiguration> WATER_CATTAIL = RuFeatureRegistry.register("water_cattail", new WaterCattailFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<TallSaplingConfiguration> TALL_SAPLING = RuFeatureRegistry.register("tall_sapling", new TallSaplingFeature(TallSaplingConfiguration.CODEC));
    public static final Feature<NoneFeatureConfiguration> ROCK_PILLAR = RuFeatureRegistry.register("rock_pillar", new RockPillarFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> LARGE_JOSHUA_TREE = RuFeatureRegistry.register("large_joshua_tree", new LargeJoshuaTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> MEDIUM_JOSHUA_TREE = RuFeatureRegistry.register("medium_joshua_tree", new MediumJoshuaTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> GIANT_PINK_BIOSHROOM = RuFeatureRegistry.register("giant_pink_bioshroom", new PinkBioshroomFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> SCULK_WILLOW = RuFeatureRegistry.register("sculk_willow", new SculkWillowFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> GIANT_SCULK_WILLOW = RuFeatureRegistry.register("giant_sculk_willow", new GiantSculkWillowFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<BlockStateConfiguration> NETHER_MEADOW_ROCK = RuFeatureRegistry.register("nether_meadow_rock", new NetherBlockBlobFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_));
    public static final Feature<NoneFeatureConfiguration> GLISTERING_IVY = RuFeatureRegistry.register("glistering_ivy", new GlisteringIvyFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> HANGING_EARLIGHT = RuFeatureRegistry.register("hanging_earlight", new HangingEarlightFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> OBSIDIAN_SPIRE = RuFeatureRegistry.register("obsidian_spire", new ObsidianSpireFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> NETHER_WILLOW = RuFeatureRegistry.register("nether_willow", new NetherWillowFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> HANGING_PRISMARITE = RuFeatureRegistry.register("hanging_prismarite", new HangingPrismariteFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<ColumnFeatureConfiguration> BASALT_BLOB = RuFeatureRegistry.register("basalt_blob", new BasaltBlobFeature((Codec<ColumnFeatureConfiguration>)ColumnFeatureConfiguration.f_67553_));
    public static final Feature<NoneFeatureConfiguration> ASH_VENT = RuFeatureRegistry.register("scorch_vent", new AshVentFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<NoneFeatureConfiguration> LAVA_FALL = RuFeatureRegistry.register("lava_fall", new LavaFallFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Feature<VegetationPatchConfiguration> OVERWORLD_LAVA_DELTA = RuFeatureRegistry.register("overworld_lava_delta", new LavaDeltaFeature((Codec<VegetationPatchConfiguration>)VegetationPatchConfiguration.f_161280_));
    public static final Feature<PointedRedstoneConfiguration> POINTED_REDSTONE = RuFeatureRegistry.register("pointed_redstone", new PointedRedstoneFeature(PointedRedstoneConfiguration.CODEC));
    public static final Feature<LargePointedRedstoneConfiguration> LARGE_POINTED_REDSTONE = RuFeatureRegistry.register("large_pointed_redstone", new LargePointedRedstoneFeature(LargePointedRedstoneConfiguration.CODEC));
    public static final Feature<PointedRedstoneClusterConfiguration> POINTED_REDSTONE_CLUSTER = RuFeatureRegistry.register("pointed_redstone_cluster", new PointedRedstoneClusterFeature(PointedRedstoneClusterConfiguration.CODEC));

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> F register(String key, F value) {
        value.setRegistryName(new ResourceLocation("regions_unexplored", key));
        ForgeRegistries.FEATURES.register(value);
        return value;
    }

    private static RegistryObject<Feature<?>> registerStructure(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

