/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import net.regions_unexplored.data.tags.RegionsUnexploredTags;

public class BasaltBlobFeature
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.f_50652_, (Object)Blocks.f_50409_, (Object)Blocks.f_50157_, (Object)Blocks.f_50079_, (Object)Blocks.f_50647_, (Object)Blocks.f_50633_, (Object)Blocks.f_50222_, (Object)Blocks.f_50223_, (Object)Blocks.f_50224_, (Object)Blocks.f_50411_, (Object)Blocks.f_50452_, (Object)Blocks.f_50601_, (Object[])new Block[]{Blocks.f_50640_, Blocks.f_50645_, Blocks.f_50411_, Blocks.f_50353_, Blocks.f_50134_, Blocks.f_50135_, Blocks.f_50387_, Blocks.f_50281_, Blocks.f_50175_, Blocks.f_50602_, Blocks.f_50646_, Blocks.f_50643_, Blocks.f_50641_, Blocks.f_50632_, Blocks.f_50629_, Blocks.f_50183_, Blocks.f_50136_, Blocks.f_49994_, Blocks.f_50645_, Blocks.f_49991_, Blocks.f_50752_, Blocks.f_50450_, Blocks.f_50135_, Blocks.f_50197_, Blocks.f_50198_, Blocks.f_50199_, Blocks.f_50200_, Blocks.f_50087_});

    public BasaltBlobFeature(Codec<ColumnFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ColumnFeatureConfiguration> context) {
        int i = context.m_159775_().m_6337_();
        BlockPos blockpos = context.m_159777_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        Random Random2 = context.m_159776_();
        ColumnFeatureConfiguration columnfeatureconfiguration = (ColumnFeatureConfiguration)context.m_159778_();
        if (!BasaltBlobFeature.canPlaceAt((LevelAccessor)worldgenlevel, i, blockpos.m_122032_())) {
            return false;
        }
        int j = columnfeatureconfiguration.m_160720_().m_142270_(Random2);
        boolean flag = Random2.nextFloat() < 0.9f;
        int k = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockpos1 : BlockPos.m_121957_((Random)Random2, (int)l, (int)(blockpos.m_123341_() - k), (int)blockpos.m_123342_(), (int)(blockpos.m_123343_() - k), (int)(blockpos.m_123341_() + k), (int)blockpos.m_123342_(), (int)(blockpos.m_123343_() + k))) {
            int i1 = j - blockpos1.m_123333_((Vec3i)blockpos);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn((LevelAccessor)worldgenlevel, i, blockpos1, i1, columnfeatureconfiguration.m_160717_().m_142270_(Random2));
        }
        return flag1;
    }

    private boolean placeColumn(LevelAccessor level, int ylevel, BlockPos pos, int k, int offset) {
        boolean flag = false;
        block0: for (BlockPos blockpos : BlockPos.m_121976_((int)(pos.m_123341_() - offset), (int)pos.m_123342_(), (int)(pos.m_123343_() - offset), (int)(pos.m_123341_() + offset), (int)pos.m_123342_(), (int)(pos.m_123343_() + offset))) {
            int i = blockpos.m_123333_((Vec3i)pos);
            BlockPos pos1 = BasaltBlobFeature.isAirOrLavaOcean(level, ylevel, blockpos) ? BasaltBlobFeature.findSurface(level, ylevel, blockpos.m_122032_(), i) : BasaltBlobFeature.findAir(level, blockpos.m_122032_(), i);
            if (pos1 == null) continue;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos1.m_122032_();
            for (int j = k - i / 2; j >= 0; --j) {
                if (BasaltBlobFeature.isAirOrLavaOcean(level, ylevel, (BlockPos)blockpos$mutableblockpos)) {
                    this.m_5974_((LevelWriter)level, (BlockPos)blockpos$mutableblockpos, Blocks.f_50137_.m_49966_());
                    blockpos$mutableblockpos.m_122173_(Direction.UP);
                    flag = true;
                    continue;
                }
                if (!level.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_(Blocks.f_50137_)) continue block0;
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            }
        }
        return flag;
    }

    @Nullable
    private static BlockPos findSurface(LevelAccessor level, int ylevel, BlockPos.MutableBlockPos pos, int i) {
        while (pos.m_123342_() > level.m_141937_() + 1 && i > 0) {
            --i;
            if (BasaltBlobFeature.canPlaceAt(level, ylevel, pos)) {
                return pos;
            }
            pos.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor level, int ylevel, BlockPos.MutableBlockPos pos) {
        if (!BasaltBlobFeature.isAirOrLavaOcean(level, ylevel, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = level.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN));
        pos.m_122173_(Direction.UP);
        return !blockstate.m_60795_() && !CANNOT_PLACE_ON.contains((Object)blockstate.m_60734_());
    }

    @Nullable
    private static BlockPos findAir(LevelAccessor level, BlockPos.MutableBlockPos pos, int i) {
        while (pos.m_123342_() < level.m_151558_() && i > 0) {
            --i;
            BlockState blockstate = level.m_8055_((BlockPos)pos);
            if (CANNOT_PLACE_ON.contains((Object)blockstate.m_60734_())) {
                return null;
            }
            if (blockstate.m_60795_()) {
                return pos;
            }
            pos.m_122173_(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(LevelAccessor levelAccessor, int ylevel, BlockPos pos) {
        BlockState blockstate = levelAccessor.m_8055_(pos);
        return blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49991_) || blockstate.m_204336_(RegionsUnexploredTags.REPLACEABLE_BLOCKS) || blockstate.m_60713_(Blocks.f_49990_) && pos.m_123342_() <= ylevel;
    }
}

