/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RegionsUnexploredBlocks;

public class GlisteringIvyFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public GlisteringIvyFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random Random2 = context.m_159776_();
        if (!worldgenlevel.m_46859_(pos)) {
            return false;
        }
        BlockState blockstate = worldgenlevel.m_8055_(pos.m_7494_());
        if (!blockstate.m_60713_(Blocks.f_50134_) && !blockstate.m_60713_((Block)RegionsUnexploredBlocks.GLISTERING_WART.get())) {
            return false;
        }
        this.placeRoofGlisteringWart((LevelAccessor)worldgenlevel, Random2, pos);
        this.placeRoofGlisteringIvy((LevelAccessor)worldgenlevel, Random2, pos);
        return true;
    }

    private void placeRoofGlisteringWart(LevelAccessor level, Random random, BlockPos pos) {
        level.m_7731_(pos, ((Block)RegionsUnexploredBlocks.GLISTERING_WART.get()).m_49966_(), 2);
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 200; ++i) {
            pos1.m_122154_((Vec3i)pos, random.nextInt(6) - random.nextInt(6), random.nextInt(2) - random.nextInt(5), random.nextInt(6) - random.nextInt(6));
            if (!level.m_46859_((BlockPos)pos1)) continue;
            int j = 0;
            for (Direction direction : DIRECTIONS) {
                BlockState blockstate = level.m_8055_((BlockPos)pos2.m_122159_((Vec3i)pos1, direction));
                if (blockstate.m_60713_(Blocks.f_50134_) || blockstate.m_60713_((Block)RegionsUnexploredBlocks.GLISTERING_WART.get())) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            level.m_7731_((BlockPos)pos1, ((Block)RegionsUnexploredBlocks.GLISTERING_WART.get()).m_49966_(), 2);
        }
    }

    private void placeRoofGlisteringIvy(LevelAccessor level, Random random, BlockPos pos) {
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            BlockState blockstate;
            pos1.m_122154_((Vec3i)pos, random.nextInt(8) - random.nextInt(8), random.nextInt(2) - random.nextInt(7), random.nextInt(8) - random.nextInt(8));
            if (!level.m_46859_((BlockPos)pos1) || !(blockstate = level.m_8055_(pos1.m_7494_())).m_60713_(Blocks.f_50134_) && !blockstate.m_60713_((Block)RegionsUnexploredBlocks.GLISTERING_WART.get())) continue;
            int j = Mth.m_14072_((Random)random, (int)1, (int)25);
            if (random.nextInt(6) == 0) {
                j *= 2;
            }
            if (random.nextInt(5) == 0) {
                j = 1;
            }
            GlisteringIvyFeature.placeGlisteringIvyColumn(level, random, pos1, j, 17, 25);
        }
    }

    public static void placeGlisteringIvyColumn(LevelAccessor level, Random random, BlockPos.MutableBlockPos pos, int length, int low, int high) {
        for (int i = 0; i <= length; ++i) {
            if (level.m_46859_((BlockPos)pos)) {
                if (i == length || !level.m_46859_(pos.m_7495_())) {
                    level.m_7731_((BlockPos)pos, (BlockState)((Block)RegionsUnexploredBlocks.GLISTERING_IVY.get()).m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_14072_((Random)random, (int)low, (int)high))), 2);
                    break;
                }
                level.m_7731_((BlockPos)pos, ((Block)RegionsUnexploredBlocks.GLISTERING_IVY_PLANT.get()).m_49966_(), 2);
            }
            pos.m_122173_(Direction.DOWN);
        }
    }
}

