/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.feature.redstonefeatures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;
import net.regions_unexplored.block.RegionsUnexploredBlocks;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.LargePointedRedstoneConfiguration;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneUtils;

public class LargePointedRedstoneFeature
extends Feature<LargePointedRedstoneConfiguration> {
    public LargePointedRedstoneFeature(Codec<LargePointedRedstoneConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<LargePointedRedstoneConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        LargePointedRedstoneConfiguration largeRedstoneConfiguration = (LargePointedRedstoneConfiguration)context.m_159778_();
        Random random = context.m_159776_();
        if (!PointedRedstoneUtils.isEmptyOrWater((LevelAccessor)level, pos)) {
            return false;
        }
        Optional optional = Column.m_158175_((LevelSimulatedReader)level, (BlockPos)pos, (int)largeRedstoneConfiguration.floorToCeilingSearchRange, PointedRedstoneUtils::isEmptyOrWater, PointedRedstoneUtils::isRedstoneBaseOrLava);
        if (optional.isPresent() && optional.get() instanceof Column.Range) {
            Column.Range columnRange = (Column.Range)optional.get();
            if (columnRange.m_158214_() < 4) {
                return false;
            }
            int i = (int)((float)columnRange.m_158214_() * largeRedstoneConfiguration.maxColumnRadiusToCaveHeightRatio);
            int j = Mth.m_14045_((int)i, (int)largeRedstoneConfiguration.columnRadius.m_142739_(), (int)largeRedstoneConfiguration.columnRadius.m_142737_());
            int k = Mth.m_144928_((Random)random, (int)largeRedstoneConfiguration.columnRadius.m_142739_(), (int)j);
            LargeRedstone largeRedstone = LargePointedRedstoneFeature.makeRedstone(pos.m_175288_(columnRange.m_158212_() - 1), false, random, k, largeRedstoneConfiguration.stalactiteBluntness, largeRedstoneConfiguration.heightScale);
            LargeRedstone largeRedstone1 = LargePointedRedstoneFeature.makeRedstone(pos.m_175288_(columnRange.m_158213_() + 1), true, random, k, largeRedstoneConfiguration.stalagmiteBluntness, largeRedstoneConfiguration.heightScale);
            WindOffsetter windOffsetter = largeRedstone.isSuitableForWind(largeRedstoneConfiguration) && largeRedstone1.isSuitableForWind(largeRedstoneConfiguration) ? new WindOffsetter(pos.m_123342_(), random, largeRedstoneConfiguration.windSpeed) : WindOffsetter.noWind();
            boolean flag = largeRedstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level, windOffsetter);
            boolean flag1 = largeRedstone1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level, windOffsetter);
            if (flag) {
                largeRedstone.placeBlocks(level, random, windOffsetter);
            }
            if (flag1) {
                largeRedstone1.placeBlocks(level, random, windOffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeRedstone makeRedstone(BlockPos pos, boolean pointingUp, Random random, int radius, FloatProvider bluntness, FloatProvider scale) {
        return new LargeRedstone(pos, pointingUp, radius, bluntness.m_142269_(random), scale.m_142269_(random));
    }

    static final class LargeRedstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeRedstone(BlockPos pos, boolean pointingUp, int radius, double bluntness, double scale) {
            this.root = pos;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel level, WindOffsetter windOffsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos pos = this.root.m_122032_();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (level.m_8055_((BlockPos)pos).m_60713_(Blocks.f_49991_)) {
                        return false;
                    }
                    if (PointedRedstoneUtils.isCircleMostlyEmbeddedInStone(level, windOffsetter.offset((BlockPos)pos), this.radius)) {
                        this.root = pos;
                        return true;
                    }
                    pos.m_122173_(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float v) {
            return (int)PointedRedstoneUtils.getRedstoneHeight(v, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel level, Random random, WindOffsetter windOffsetter) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                block1: for (int j = -this.radius; j <= this.radius; ++j) {
                    int k;
                    float f = Mth.m_14116_((float)(i * i + j * j));
                    if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if ((double)random.nextFloat() < 0.2) {
                        k = (int)((float)k * Mth.m_144924_((Random)random, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos pos = this.root.m_142082_(i, 0, j).m_122032_();
                    boolean flag = false;
                    int l = this.pointingUp ? level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_()) : Integer.MAX_VALUE;
                    for (int i1 = 0; i1 < k && pos.m_123342_() < l; ++i1) {
                        BlockPos blockpos = windOffsetter.offset((BlockPos)pos);
                        if (PointedRedstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)level, blockpos)) {
                            flag = true;
                            Block block = (Block)RegionsUnexploredBlocks.RAW_REDSTONE_BLOCK.get();
                            level.m_7731_(blockpos, block.m_49966_(), 2);
                        } else if (flag && level.m_8055_(blockpos).m_204336_(BlockTags.f_13061_)) continue block1;
                        pos.m_122173_(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        boolean isSuitableForWind(LargePointedRedstoneConfiguration largeRedstoneConfiguration) {
            return this.radius >= largeRedstoneConfiguration.minRadiusForWind && this.bluntness >= (double)largeRedstoneConfiguration.minBluntnessForWind;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int originY, Random random, FloatProvider floatProvider) {
            this.originY = originY;
            float f = floatProvider.m_142269_(random);
            float f1 = Mth.m_144924_((Random)random, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new Vec3((double)(Mth.m_14089_((float)f1) * f), 0.0, (double)(Mth.m_14031_((float)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos pos) {
            if (this.windSpeed == null) {
                return pos;
            }
            int i = this.originY - pos.m_123342_();
            Vec3 vec3 = this.windSpeed.m_82490_((double)i);
            return pos.m_142022_(vec3.f_82479_, 0.0, vec3.f_82481_);
        }
    }
}

