/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.feature.redstonefeatures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RegionsUnexploredBlocks;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneClusterConfiguration;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneUtils;

public class PointedRedstoneClusterFeature
extends Feature<PointedRedstoneClusterConfiguration> {
    public PointedRedstoneClusterFeature(Codec<PointedRedstoneClusterConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<PointedRedstoneClusterConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        PointedRedstoneClusterConfiguration redstoneClusterConfiguration = (PointedRedstoneClusterConfiguration)context.m_159778_();
        Random random = context.m_159776_();
        if (!PointedRedstoneUtils.isEmptyOrWater((LevelAccessor)level, pos)) {
            return false;
        }
        int i = redstoneClusterConfiguration.height.m_142270_(random);
        float f = redstoneClusterConfiguration.wetness.m_142269_(random);
        float f1 = redstoneClusterConfiguration.density.m_142269_(random);
        int j = redstoneClusterConfiguration.radius.m_142270_(random);
        int k = redstoneClusterConfiguration.radius.m_142270_(random);
        for (int l = -j; l <= j; ++l) {
            for (int i1 = -k; i1 <= k; ++i1) {
                double d0 = this.getChanceOfStalagmiteOrStalactite(j, k, l, i1, redstoneClusterConfiguration);
                BlockPos blockpos1 = pos.m_142082_(l, 0, i1);
                this.placeColumn(level, random, blockpos1, l, i1, f, d0, i, f1, redstoneClusterConfiguration);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel level, Random random, BlockPos pos, int i4, int i5, float v, double v1, int i6, float v2, PointedRedstoneClusterConfiguration redstoneClusterConfiguration) {
        Optional optional = Column.m_158175_((LevelSimulatedReader)level, (BlockPos)pos, (int)redstoneClusterConfiguration.floorToCeilingSearchRange, PointedRedstoneUtils::isEmptyOrWater, PointedRedstoneUtils::isNeitherEmptyNorWater);
        if (optional.isPresent()) {
            OptionalInt optionalInt = ((Column)optional.get()).m_142011_();
            OptionalInt optionalInt1 = ((Column)optional.get()).m_142009_();
            if (optionalInt.isPresent() || optionalInt1.isPresent()) {
                boolean flag3;
                int j1;
                int j3;
                int i3;
                boolean flag2;
                int j;
                boolean flag1;
                Column column;
                boolean flag;
                boolean bl = flag = random.nextFloat() < v;
                if (flag && optionalInt1.isPresent() && this.canPlacePool(level, pos.m_175288_(optionalInt1.getAsInt()))) {
                    int i = optionalInt1.getAsInt();
                    column = ((Column)optional.get()).m_158181_(OptionalInt.of(i - 1));
                    level.m_7731_(pos.m_175288_(i), Blocks.f_49990_.m_49966_(), 2);
                } else {
                    column = (Column)optional.get();
                }
                OptionalInt optionalint2 = column.m_142009_();
                boolean bl2 = flag1 = random.nextDouble() < v1;
                if (optionalInt.isPresent() && flag1 && !this.isLava((LevelReader)level, pos.m_175288_(optionalInt.getAsInt()))) {
                    int k = redstoneClusterConfiguration.redstoneBlockLayerThickness.m_142270_(random);
                    this.replaceBlocksWithRedstoneBlocks(level, pos.m_175288_(optionalInt.getAsInt()), k, Direction.UP);
                    int l = optionalint2.isPresent() ? Math.min(i6, optionalInt.getAsInt() - optionalint2.getAsInt()) : i6;
                    j = this.getRedstoneHeight(random, i4, i5, v2, l, redstoneClusterConfiguration);
                } else {
                    j = 0;
                }
                boolean bl3 = flag2 = random.nextDouble() < v1;
                if (optionalint2.isPresent() && flag2 && !this.isLava((LevelReader)level, pos.m_175288_(optionalint2.getAsInt()))) {
                    int i1 = redstoneClusterConfiguration.redstoneBlockLayerThickness.m_142270_(random);
                    this.replaceBlocksWithRedstoneBlocks(level, pos.m_175288_(optionalint2.getAsInt()), i1, Direction.DOWN);
                    i3 = optionalInt.isPresent() ? Math.max(0, j + Mth.m_144928_((Random)random, (int)(-redstoneClusterConfiguration.maxStalagmiteStalactiteHeightDiff), (int)redstoneClusterConfiguration.maxStalagmiteStalactiteHeightDiff)) : this.getRedstoneHeight(random, i4, i5, v2, i6, redstoneClusterConfiguration);
                } else {
                    i3 = 0;
                }
                if (optionalInt.isPresent() && optionalint2.isPresent() && optionalInt.getAsInt() - j <= optionalint2.getAsInt() + i3) {
                    int k1 = optionalint2.getAsInt();
                    int l1 = optionalInt.getAsInt();
                    int i2 = Math.max(l1 - j, k1 + 1);
                    int j2 = Math.min(k1 + i3, l1 - 1);
                    int k2 = Mth.m_144928_((Random)random, (int)i2, (int)(j2 + 1));
                    int l2 = k2 - 1;
                    j3 = l1 - k2;
                    j1 = l2 - k1;
                } else {
                    j3 = j;
                    j1 = i3;
                }
                boolean bl4 = flag3 = random.nextBoolean() && j3 > 0 && j1 > 0 && column.m_142030_().isPresent() && j3 + j1 == column.m_142030_().getAsInt();
                if (optionalInt.isPresent()) {
                    PointedRedstoneUtils.growPointedRedstone((LevelAccessor)level, pos.m_175288_(optionalInt.getAsInt() - 1), Direction.DOWN, j3, flag3);
                }
                if (optionalint2.isPresent()) {
                    PointedRedstoneUtils.growPointedRedstone((LevelAccessor)level, pos.m_175288_(optionalint2.getAsInt() + 1), Direction.UP, j1, flag3);
                }
            }
        }
    }

    private boolean isLava(LevelReader level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_(Blocks.f_49991_);
    }

    private int getRedstoneHeight(Random random, int i1, int i2, float v, int i3, PointedRedstoneClusterConfiguration redstoneClusterConfiguration) {
        if (random.nextFloat() > v) {
            return 0;
        }
        int i = Math.abs(i1) + Math.abs(i2);
        float f = (float)Mth.m_144851_((double)i, (double)0.0, (double)redstoneClusterConfiguration.maxDistanceFromCenterAffectingHeightBias, (double)((double)i3 / 2.0), (double)0.0);
        return (int)PointedRedstoneClusterFeature.randomBetweenBiased(random, 0.0f, i3, f, redstoneClusterConfiguration.heightDeviation);
    }

    private boolean canPlacePool(WorldGenLevel level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        if (!(blockstate.m_60713_(Blocks.f_50301_) || blockstate.m_60713_((Block)RegionsUnexploredBlocks.RAW_REDSTONE_BLOCK.get()) || blockstate.m_60713_((Block)RegionsUnexploredBlocks.POINTED_REDSTONE.get()))) {
            if (level.m_8055_(pos.m_7494_()).m_60819_().m_205070_(FluidTags.f_13131_)) {
                return false;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.canBeAdjacentToWater((LevelAccessor)level, pos.m_142300_(direction))) continue;
                return false;
            }
            return this.canBeAdjacentToWater((LevelAccessor)level, pos.m_7495_());
        }
        return false;
    }

    private boolean canBeAdjacentToWater(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        return blockstate.m_204336_(BlockTags.f_13061_) || blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    private void replaceBlocksWithRedstoneBlocks(WorldGenLevel level, BlockPos pos, int i1, Direction direction) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (int i = 0; i < i1; ++i) {
            if (!PointedRedstoneUtils.placeRedstoneBlockIfPossible((LevelAccessor)level, (BlockPos)blockpos$mutableblockpos)) {
                return;
            }
            blockpos$mutableblockpos.m_122173_(direction);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int i1, int i2, int i3, int i4, PointedRedstoneClusterConfiguration redstoneClusterConfiguration) {
        int i = i1 - Math.abs(i3);
        int j = i2 - Math.abs(i4);
        int k = Math.min(i, j);
        return Mth.m_184631_((float)k, (float)0.0f, (float)redstoneClusterConfiguration.maxDistanceFromEdgeAffectingChanceOfRedstoneColumn, (float)redstoneClusterConfiguration.chanceOfRedstoneColumnAtMaxDistanceFromCenter, (float)1.0f);
    }

    private static float randomBetweenBiased(Random random, float v, float v1, float v2, float v3) {
        return ClampedNormalFloat.m_146434_((Random)random, (float)v2, (float)v3, (float)v, (float)v1);
    }
}

