/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.feature.redstonefeatures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneConfiguration;
import net.regions_unexplored.data.worldgen.features.feature.redstonefeatures.PointedRedstoneUtils;

public class PointedRedstoneFeature<P>
extends Feature<PointedRedstoneConfiguration> {
    public PointedRedstoneFeature(Codec<PointedRedstoneConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<PointedRedstoneConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        PointedRedstoneConfiguration redstoneConfiguration = (PointedRedstoneConfiguration)context.m_159778_();
        Optional<Direction> optional = PointedRedstoneFeature.getTipDirection((LevelAccessor)level, pos, random);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockpos1 = pos.m_142300_(optional.get().m_122424_());
        PointedRedstoneFeature.createPatchOfRedstoneBlocks((LevelAccessor)level, random, blockpos1, redstoneConfiguration);
        int i = random.nextFloat() < redstoneConfiguration.chanceOfTallerRedstone && PointedRedstoneUtils.isEmptyOrWater(level.m_8055_(pos.m_142300_(optional.get()))) ? 2 : 1;
        PointedRedstoneUtils.growPointedRedstone((LevelAccessor)level, pos, optional.get(), i, false);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor level, BlockPos pos, Random random) {
        boolean flag = PointedRedstoneUtils.isRedstoneBase(level.m_8055_(pos.m_7494_()));
        boolean flag1 = PointedRedstoneUtils.isRedstoneBase(level.m_8055_(pos.m_7495_()));
        if (flag && flag1) {
            return Optional.of(random.nextBoolean() ? Direction.DOWN : Direction.UP);
        }
        if (flag) {
            return Optional.of(Direction.DOWN);
        }
        return flag1 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void createPatchOfRedstoneBlocks(LevelAccessor level, Random random, BlockPos pos, PointedRedstoneConfiguration redstoneConfiguration) {
        PointedRedstoneUtils.placeRedstoneBlockIfPossible(level, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (random.nextFloat() > redstoneConfiguration.chanceOfDirectionalSpread) continue;
            BlockPos blockpos = pos.m_142300_(direction);
            PointedRedstoneUtils.placeRedstoneBlockIfPossible(level, blockpos);
            if (random.nextFloat() > redstoneConfiguration.chanceOfSpreadRadius2) continue;
            BlockPos blockpos1 = blockpos.m_142300_(Direction.m_122404_((Random)random));
            PointedRedstoneUtils.placeRedstoneBlockIfPossible(level, blockpos1);
            if (random.nextFloat() > redstoneConfiguration.chanceOfSpreadRadius3) continue;
            BlockPos blockpos2 = blockpos1.m_142300_(Direction.m_122404_((Random)random));
            PointedRedstoneUtils.placeRedstoneBlockIfPossible(level, blockpos2);
        }
    }
}

