/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.features.treedecorators;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.regions_unexplored.block.RegionsUnexploredBlocks;
import net.regions_unexplored.world.features.treedecorators.SaguaroCactusLimbs;

public class SpanishMossDecorator
extends LeaveVineDecorator {
    public static final SpanishMossDecorator INSTANCE = new SpanishMossDecorator();
    public static Codec<SpanishMossDecorator> codec = Codec.unit(() -> INSTANCE);
    public static TreeDecoratorType<?> tdt = new TreeDecoratorType(codec);

    protected TreeDecoratorType<?> m_6663_() {
        return tdt;
    }

    public void m_142741_(LevelSimulatedReader levelReader, BiConsumer<BlockPos, BlockState> biConsumer, Random random, List<BlockPos> listBlockPos, List<BlockPos> listBlockPos2) {
        listBlockPos2.forEach(blockpos -> {
            BlockPos bp;
            if (random.nextInt(4) == 0 && SpanishMossDecorator.isAirBlock(levelReader, bp = blockpos.m_7495_())) {
                SpanishMossDecorator.addVine(levelReader, bp, random, biConsumer);
            }
        });
    }

    private static void addVine(LevelSimulatedReader levelReader, BlockPos pos, Random random, BiConsumer<BlockPos, BlockState> biConsumer) {
        int size = random.nextInt(4);
        BlockPos place = pos;
        for (int i = 0; i <= size; ++i) {
            if (SpanishMossDecorator.isAirBlock(levelReader, place)) {
                if (i == size) {
                    biConsumer.accept(place, ((Block)RegionsUnexploredBlocks.SPANISH_MOSS.get()).m_49966_());
                } else {
                    biConsumer.accept(place, ((Block)RegionsUnexploredBlocks.SPANISH_MOSS_PLANT.get()).m_49966_());
                }
            } else {
                if (i == 0) break;
                biConsumer.accept(place.m_7494_(), ((Block)RegionsUnexploredBlocks.SPANISH_MOSS.get()).m_49966_());
                break;
            }
            place = place.m_7495_();
        }
    }

    public static boolean isAir(BlockState p_159760_) {
        return p_159760_.m_60713_(Blocks.f_50016_) || p_159760_.m_60713_(Blocks.f_50627_) || p_159760_.m_60713_(Blocks.f_50626_);
    }

    public static boolean isAirBlock(LevelSimulatedReader p_65789_, BlockPos p_65790_) {
        return p_65789_.m_7433_(p_65790_, SaguaroCactusLimbs::isAir);
    }

    static {
        tdt.setRegistryName("spanish_moss_leave_decorator");
    }
}

