/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.biome;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.regions_unexplored.data.worldgen.biome.RuBiomes;
import net.regions_unexplored.util.worldgen.CheckBiomeConfig;

public class RegionSecondaryBiomeBuilder {
    private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    private final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
    private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
    private final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
    private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
    private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
    private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
    private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
    private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
    private final ResourceKey<Biome>[][] VANILLA_OCEANS = new ResourceKey[][]{{Biomes.f_48172_, Biomes.f_48171_, Biomes.f_48225_, Biomes.f_48170_, Biomes.f_48166_}, {Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48174_, Biomes.f_48167_, Biomes.f_48166_}};
    private final ResourceKey<Biome>[][] VANILLA_MIDDLE_BIOMES = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48206_}, {Biomes.f_48202_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186764_}, {Biomes.f_48179_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48151_}, {Biomes.f_48157_, Biomes.f_48157_, Biomes.f_48205_, Biomes.f_48222_, Biomes.f_48222_}, {Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_}};
    private final ResourceKey<Biome>[][] VANILLA_MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48182_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_, Biomes.f_48206_}, {Biomes.f_48202_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186763_}, {Biomes.f_48176_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_186762_, Biomes.f_48151_}, {Biomes.f_48157_, Biomes.f_48157_, Biomes.f_48202_, Biomes.f_186769_, Biomes.f_48197_}, {Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_}};
    private final ResourceKey<Biome>[][] VANILLA_PLATEAU_BIOMES = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186764_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48151_}, {Biomes.f_48158_, Biomes.f_48158_, Biomes.f_48205_, Biomes.f_48205_, Biomes.f_48222_}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}};
    private final ResourceKey<Biome>[][] VANILLA_PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48182_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186763_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48151_}, {Biomes.f_48158_, Biomes.f_48158_, Biomes.f_48205_, Biomes.f_48205_, Biomes.f_48222_}, {Biomes.f_48194_, Biomes.f_48194_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}};
    private final ResourceKey<Biome>[][] VANILLA_SHATTERED_BIOMES = new ResourceKey[][]{{Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_48157_, Biomes.f_48157_, Biomes.f_48205_, Biomes.f_48222_, Biomes.f_48222_}, {Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_}};
    private final ResourceKey<Biome>[][] VANILLA_RIVER_BIOMES = new ResourceKey[][]{{Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}};
    private final ResourceKey<Biome>[][] VANILLA_RIVER_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{RuBiomes.ICY_DESERT, RuBiomes.FROZEN_TUNDRA, RuBiomes.FROZEN_TUNDRA, RuBiomes.COLD_BOREAL_FOREST, RuBiomes.ALPHA_GROVE}, {RuBiomes.POPPY_FIELDS, RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_FOREST}, {RuBiomes.MAUVE_HILLS, RuBiomes.MEADOW, RuBiomes.CHERRY_HILLS, RuBiomes.LUPINE_PLAINS, RuBiomes.BLACKWOOD_FOREST}, {RuBiomes.MEADOW, RuBiomes.MEADOW, RuBiomes.BAMBOO_FOREST, RuBiomes.WILLOW_FOREST, RuBiomes.WILLOW_FOREST}, {RuBiomes.OUTBACK, RuBiomes.OUTBACK, RuBiomes.OUTBACK, RuBiomes.OUTBACK, RuBiomes.EUCALYPTUS_FOREST}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{RuBiomes.SPIRES, RuBiomes.FROZEN_TUNDRA, RuBiomes.FROZEN_TUNDRA, RuBiomes.COLD_BOREAL_FOREST, RuBiomes.COLD_BOREAL_FOREST}, {RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.SILVER_BIRCH_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_FOREST, RuBiomes.GOLDEN_BOREAL_FOREST}, {RuBiomes.MAUVE_HILLS, RuBiomes.MEADOW, RuBiomes.CHERRY_HILLS, RuBiomes.LUPINE_PLAINS, RuBiomes.BLACKWOOD_FOREST}, {RuBiomes.MEADOW, RuBiomes.MEADOW, RuBiomes.WILLOW_FOREST, RuBiomes.WILLOW_FOREST, RuBiomes.FLOWER_FIELD}, {RuBiomes.OUTBACK, RuBiomes.OUTBACK, RuBiomes.GRASSLAND, RuBiomes.GRASSLAND, RuBiomes.EUCALYPTUS_FOREST}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ALPHA_GROVE}, {RuBiomes.POPPY_FIELDS, RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_FOREST, RuBiomes.BOREAL_FOREST}, {RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.HIGHLAND_FIELDS, RuBiomes.BLACKWOOD_FOREST}, {RuBiomes.CHERRY_HILLS, RuBiomes.CHERRY_HILLS, RuBiomes.CHERRY_HILLS, RuBiomes.CHERRY_HILLS, RuBiomes.FLOWER_FIELD}, {RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{RuBiomes.SPIRES, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.COLD_BOREAL_FOREST}, {RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.MAPLE_FOREST, RuBiomes.BOREAL_FOREST, RuBiomes.GOLDEN_BOREAL_FOREST}, {RuBiomes.HIGHLAND_FIELDS, RuBiomes.CHERRY_HILLS, RuBiomes.CHERRY_HILLS, RuBiomes.CHERRY_HILLS, RuBiomes.BLACKWOOD_FOREST}, {RuBiomes.CHERRY_HILLS, RuBiomes.CHERRY_HILLS, RuBiomes.CHERRY_HILLS, RuBiomes.CHERRY_HILLS, RuBiomes.FLOWER_FIELD}, {RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST}};
    private final ResourceKey<Biome>[][] SHATTERED_BIOMES = new ResourceKey[][]{{RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS, RuBiomes.ICY_HEIGHTS}, {RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS, RuBiomes.TOWERING_CLIFFS}, {RuBiomes.LUSH_HILLS, RuBiomes.LUSH_HILLS, RuBiomes.LUSH_HILLS, RuBiomes.LUSH_HILLS, RuBiomes.LUSH_HILLS}, {RuBiomes.MEADOW, RuBiomes.MEADOW, RuBiomes.BAMBOO_FOREST, RuBiomes.FLOWER_FIELD, RuBiomes.FLOWER_FIELD}, {RuBiomes.OUTBACK, RuBiomes.OUTBACK, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST, RuBiomes.EUCALYPTUS_FOREST}};
    private final ResourceKey<Biome>[][] RIVER_BIOMES = new ResourceKey[][]{{Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_}, {RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER}, {RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.BLACKWOOD_FOREST}, {RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER}, {RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER}};
    private final ResourceKey<Biome>[][] RIVER_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_, Biomes.f_48212_}, {RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER, RuBiomes.COLD_RIVER}, {RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.BLACKWOOD_FOREST}, {RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.BAMBOO_FOREST, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER}, {RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER, RuBiomes.MUDDY_RIVER}};

    protected void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addOffCoastBiomes(builder);
        this.addInlandBiomes(builder);
        this.addUndergroundBiomes(builder);
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addSurfaceBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.SMOULDERING_WOODLAND) ? RuBiomes.SMOULDERING_WOODLAND : Biomes.f_48215_));
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            this.addSurfaceBiome(builder, climate$parameter, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA_OCEANS[0][i]);
            this.addSurfaceBiome(builder, climate$parameter, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA_OCEANS[1][i]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addMidSlice(builder, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(builder, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(builder, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(builder, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(builder, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(builder, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
        this.addValleys(builder, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
        this.addLowSlice(builder, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
        this.addMidSlice(builder, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
        this.addHighSlice(builder, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
        this.addPeaks(builder, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(builder, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(builder, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrArid = this.pickMiddleBiomeOrAridIfHot(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrAridOrCold = this.pickMiddleBiomeOrAridIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, shatteredBiome);
                ResourceKey<Biome> peakBiomes = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomes);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBiomeOrAridOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, peakBiomes);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiomeOrArid);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrArid = this.pickMiddleBiomeOrAridIfHot(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrAridOrCold = this.pickMiddleBiomeOrAridIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                ResourceKey<Biome> slopeBiome = this.pickSlopeBiome(i, j, weirdness);
                ResourceKey<Biome> peakBiome = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, middleBiomeOrAridOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiomeOrArid);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                if (i == 4) {
                    if (j == 0 || j == 1) {
                        this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FUNGAL_FEN) ? RuBiomes.FUNGAL_FEN : Biomes.f_48207_));
                        continue;
                    }
                    this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
                    continue;
                }
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        ResourceKey chalkCliffs = CheckBiomeConfig.isBiomeEnabled(RuBiomes.CHALK_CLIFFS) ? RuBiomes.CHALK_CLIFFS : Biomes.f_186760_;
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[0], (Climate.Parameter)this.temperatures[2]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_186760_);
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, (ResourceKey<Biome>)chalkCliffs);
        ResourceKey bayouBiome = CheckBiomeConfig.isBiomeEnabled(RuBiomes.BAYOU) ? RuBiomes.BAYOU : Biomes.f_48207_;
        ResourceKey giantBayouBiome = CheckBiomeConfig.isBiomeEnabled(RuBiomes.GIANT_BAYOU) ? RuBiomes.GIANT_BAYOU : Biomes.f_48207_;
        this.addSurfaceBiome(builder, this.temperatures[1], this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FEN) ? RuBiomes.FEN : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.temperatures[2], this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.f_186814_() < 0L ? giantBayouBiome : bayouBiome));
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[2], (Climate.Parameter)this.humidities[4]), Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.TROPICS) ? RuBiomes.TROPICS : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.temperatures[3], Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[0], (Climate.Parameter)this.humidities[1]), Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FLOODED_PLAINS) ? RuBiomes.FLOODED_PLAINS : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.temperatures[4], Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[0], (Climate.Parameter)this.humidities[1]), Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FUNGAL_FEN) ? RuBiomes.FUNGAL_FEN : Biomes.f_48207_));
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrArid = this.pickMiddleBiomeOrAridIfHot(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrAridOrCold = this.pickMiddleBiomeOrAridIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> beachBiome = this.pickBeachBiome(i, j);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                ResourceKey<Biome> slopeBiome = this.pickSlopeBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBiomeOrAridOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? slopeBiome : plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiomeOrArid);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiomeOrArid);
                if (weirdness.f_186814_() < 0L) {
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, beachBiome);
                    this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                } else {
                    this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                }
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                if (weirdness.f_186814_() < 0L) {
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                } else {
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, middleBiome);
                }
                if (i != 0) continue;
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        ResourceKey chalkCliffs = CheckBiomeConfig.isBiomeEnabled(RuBiomes.CHALK_CLIFFS) ? RuBiomes.CHALK_CLIFFS : Biomes.f_186760_;
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[0], (Climate.Parameter)this.temperatures[2]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_186760_);
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, (ResourceKey<Biome>)chalkCliffs);
        ResourceKey bayouBiome = CheckBiomeConfig.isBiomeEnabled(RuBiomes.BAYOU) ? RuBiomes.BAYOU : Biomes.f_48207_;
        ResourceKey giantBayouBiome = CheckBiomeConfig.isBiomeEnabled(RuBiomes.GIANT_BAYOU) ? RuBiomes.GIANT_BAYOU : Biomes.f_48207_;
        this.addSurfaceBiome(builder, this.temperatures[1], this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FEN) ? RuBiomes.FEN : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.temperatures[2], this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.f_186814_() < 0L ? giantBayouBiome : bayouBiome));
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[2], (Climate.Parameter)this.humidities[4]), Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.TROPICS) ? RuBiomes.TROPICS : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.temperatures[3], Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[0], (Climate.Parameter)this.humidities[1]), Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FLOODED_PLAINS) ? RuBiomes.FLOODED_PLAINS : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.temperatures[4], Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[0], (Climate.Parameter)this.humidities[1]), Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FUNGAL_FEN) ? RuBiomes.FUNGAL_FEN : Biomes.f_48207_));
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrArid = this.pickMiddleBiomeOrAridIfHot(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrAridOrCold = this.pickMiddleBiomeOrAridIfHotOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> beachBiome = this.pickBeachBiome(i, j);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeOrArid);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeOrAridOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeOrArid);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                if (i != 0) continue;
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        ResourceKey chalkCliffs = CheckBiomeConfig.isBiomeEnabled(RuBiomes.CHALK_CLIFFS) ? RuBiomes.CHALK_CLIFFS : Biomes.f_186760_;
        ResourceKey bayouBiome = CheckBiomeConfig.isBiomeEnabled(RuBiomes.BAYOU) ? RuBiomes.BAYOU : Biomes.f_48207_;
        ResourceKey giantBayouBiome = CheckBiomeConfig.isBiomeEnabled(RuBiomes.GIANT_BAYOU) ? RuBiomes.GIANT_BAYOU : Biomes.f_48207_;
        this.addSurfaceBiome(builder, this.temperatures[1], this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FEN) ? RuBiomes.FEN : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.temperatures[2], this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.f_186814_() < 0L ? giantBayouBiome : bayouBiome));
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[2], (Climate.Parameter)this.humidities[4]), Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.TROPICS) ? RuBiomes.TROPICS : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.temperatures[3], Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[0], (Climate.Parameter)this.humidities[1]), Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FLOODED_PLAINS) ? RuBiomes.FLOODED_PLAINS : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.temperatures[4], Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[0], (Climate.Parameter)this.humidities[1]), Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.FUNGAL_FEN) ? RuBiomes.FUNGAL_FEN : Biomes.f_48207_));
        this.addSurfaceBiome(builder, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeOrArid = this.pickMiddleBiomeOrAridIfHot(i, j, weirdness);
                ResourceKey<Biome> riverBiome = this.pickRiverBiome(i, j, weirdness);
                ResourceKey<Biome> cliffBiome = (float)this.temperatures[i].f_186814_() <= -0.45f ? Biomes.f_186760_ : chalkCliffs;
                ResourceKey<Biome> maybePickCliff = weirdness.f_186814_() < 0L ? cliffBiome : riverBiome;
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeOrArid);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, maybePickCliff);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, riverBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, riverBiome);
                if (i == 3 || i == 4) {
                    if (j == 2 || j == 3 || j == 4) {
                        this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.TROPICS) ? RuBiomes.TROPICS : Biomes.f_48207_));
                        continue;
                    }
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, riverBiome);
                    continue;
                }
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, riverBiome);
            }
        }
    }

    private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.79f), this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), 0.0f, (ResourceKey<Biome>)Biomes.f_151784_);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.79f), this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.REDSTONE_CAVES) ? RuBiomes.REDSTONE_CAVES : Biomes.f_151784_));
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.775f, (float)1.0f), this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.PRISMACHASM) ? RuBiomes.PRISMACHASM : Biomes.f_151784_));
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.775f, (float)1.0f), this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.REDSTONE_CAVES) ? RuBiomes.REDSTONE_CAVES : Biomes.f_151784_));
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.69f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), 0.0f, (ResourceKey<Biome>)Biomes.f_151785_);
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.69f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.LUSH_DELTA) ? RuBiomes.LUSH_DELTA : Biomes.f_151785_));
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.65f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.BIOSHROOM_CAVES) ? RuBiomes.BIOSHROOM_CAVES : Biomes.f_151785_));
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.65f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.LUSH_DELTA) ? RuBiomes.LUSH_DELTA : Biomes.f_151785_));
        this.addBottomBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.f_151785_);
        this.addBottomBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)(CheckBiomeConfig.isBiomeEnabled(RuBiomes.SCORCHING_CAVES) ? RuBiomes.SCORCHING_CAVES : Biomes.f_151784_));
    }

    private ResourceKey<Biome> pickMiddleBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            if (CheckBiomeConfig.isBiomeEnabled(this.MIDDLE_BIOMES[temperature][humidity])) {
                return this.MIDDLE_BIOMES[temperature][humidity];
            }
            return this.VANILLA_MIDDLE_BIOMES[temperature][humidity];
        }
        if (this.MIDDLE_BIOMES_VARIANT[temperature][humidity] == null) {
            if (CheckBiomeConfig.isBiomeEnabled(this.MIDDLE_BIOMES[temperature][humidity])) {
                return this.MIDDLE_BIOMES[temperature][humidity];
            }
            return this.VANILLA_MIDDLE_BIOMES[temperature][humidity];
        }
        if (CheckBiomeConfig.isBiomeEnabled(this.MIDDLE_BIOMES_VARIANT[temperature][humidity])) {
            return this.MIDDLE_BIOMES_VARIANT[temperature][humidity];
        }
        return this.VANILLA_MIDDLE_BIOMES_VARIANT[temperature][humidity];
    }

    private ResourceKey<Biome> pickMiddleBiomeOrAridIfHot(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 4 ? this.pickBadlandsBiome(humidity, weirdness) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> pickMiddleBiomeOrAridIfHotOrSlopeIfCold(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 0 ? this.pickSlopeBiome(temperature, humidity, weirdness) : this.pickMiddleBiomeOrAridIfHot(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> maybePickToweringCliffsBiome(int temperature, int humidity, Climate.Parameter weirdness, ResourceKey<Biome> fallbackBiome) {
        ResourceKey resourceKey = CheckBiomeConfig.isBiomeEnabled(RuBiomes.TOWERING_CLIFFS) ? RuBiomes.TOWERING_CLIFFS : Biomes.f_186768_;
        return temperature > 1 && humidity < 4 && weirdness.f_186814_() >= 0L ? resourceKey : fallbackBiome;
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourceKey = weirdness.f_186814_() >= 0L ? this.pickMiddleBiome(temperature, humidity, weirdness) : this.pickBeachBiome(temperature, humidity);
        return this.maybePickToweringCliffsBiome(temperature, humidity, weirdness, resourceKey);
    }

    private ResourceKey<Biome> pickBeachBiome(int temperature, int humidity) {
        if (temperature <= 1) {
            return CheckBiomeConfig.isBiomeEnabled(RuBiomes.GRAVEL_BEACH) ? RuBiomes.GRAVEL_BEACH : Biomes.f_48217_;
        }
        if (temperature == 4) {
            return Biomes.f_48217_;
        }
        return CheckBiomeConfig.isBiomeEnabled(RuBiomes.GRASSY_BEACH) ? RuBiomes.GRASSY_BEACH : Biomes.f_48217_;
    }

    private ResourceKey<Biome> pickBadlandsBiome(int humidity, Climate.Parameter weirdness) {
        if (humidity > 2) {
            if (weirdness.f_186814_() < 0L) {
                return CheckBiomeConfig.isBiomeEnabled(RuBiomes.EUCALYPTUS_FOREST) ? RuBiomes.EUCALYPTUS_FOREST : Biomes.f_48159_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RuBiomes.GRASSLAND) ? RuBiomes.GRASSLAND : Biomes.f_48194_;
        }
        if (humidity == 2) {
            return CheckBiomeConfig.isBiomeEnabled(RuBiomes.ARID_MOUNTAINS) ? RuBiomes.ARID_MOUNTAINS : Biomes.f_186753_;
        }
        return CheckBiomeConfig.isBiomeEnabled(RuBiomes.ARID_MOUNTAINS) ? RuBiomes.ARID_MOUNTAINS : Biomes.f_186753_;
    }

    private ResourceKey<Biome> pickPlateauBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            if (CheckBiomeConfig.isBiomeEnabled(this.PLATEAU_BIOMES[temperature][humidity])) {
                return this.PLATEAU_BIOMES[temperature][humidity];
            }
            return this.VANILLA_PLATEAU_BIOMES[temperature][humidity];
        }
        if (this.PLATEAU_BIOMES_VARIANT[temperature][humidity] == null) {
            if (CheckBiomeConfig.isBiomeEnabled(this.PLATEAU_BIOMES[temperature][humidity])) {
                return this.PLATEAU_BIOMES[temperature][humidity];
            }
            return this.VANILLA_PLATEAU_BIOMES[temperature][humidity];
        }
        if (CheckBiomeConfig.isBiomeEnabled(this.PLATEAU_BIOMES_VARIANT[temperature][humidity])) {
            return this.PLATEAU_BIOMES_VARIANT[temperature][humidity];
        }
        return this.VANILLA_PLATEAU_BIOMES_VARIANT[temperature][humidity];
    }

    private ResourceKey<Biome> pickPeakBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature < 1) {
            return weirdness.f_186814_() < 0L ? Biomes.f_186758_ : Biomes.f_186757_;
        }
        if (temperature == 1) {
            if (humidity < 3) {
                return weirdness.f_186814_() < 0L ? Biomes.f_186758_ : Biomes.f_186757_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RuBiomes.MOUNTAINS) ? RuBiomes.MOUNTAINS : Biomes.f_186758_;
        }
        if (temperature > 1 && temperature < 3) {
            return CheckBiomeConfig.isBiomeEnabled(RuBiomes.MOUNTAINS) ? RuBiomes.MOUNTAINS : Biomes.f_186758_;
        }
        return temperature == 3 ? Biomes.f_186759_ : this.pickBadlandsBiome(humidity, weirdness);
    }

    private ResourceKey<Biome> pickSlopeBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey icyDesert;
        ResourceKey coldDeciduousForest = CheckBiomeConfig.isBiomeEnabled(RuBiomes.COLD_DECIDUOUS_FOREST) ? RuBiomes.COLD_DECIDUOUS_FOREST : Biomes.f_186755_;
        ResourceKey resourceKey = icyDesert = CheckBiomeConfig.isBiomeEnabled(RuBiomes.ICY_DESERT) ? RuBiomes.ICY_DESERT : Biomes.f_186756_;
        if (temperature >= 3) {
            return this.pickPlateauBiome(temperature, humidity, weirdness);
        }
        if (temperature < 1) {
            return humidity <= 1 ? icyDesert : coldDeciduousForest;
        }
        if (temperature == 1) {
            if (humidity < 3) {
                return weirdness.f_186814_() < 0L ? Biomes.f_186755_ : Biomes.f_186756_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RuBiomes.PINE_SLOPES) ? RuBiomes.PINE_SLOPES : Biomes.f_186755_;
        }
        return CheckBiomeConfig.isBiomeEnabled(RuBiomes.PINE_SLOPES) ? RuBiomes.PINE_SLOPES : Biomes.f_186755_;
    }

    private ResourceKey<Biome> pickShatteredBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourceKey = CheckBiomeConfig.isBiomeEnabled(this.SHATTERED_BIOMES[temperature][humidity]) ? this.SHATTERED_BIOMES[temperature][humidity] : this.VANILLA_SHATTERED_BIOMES[temperature][humidity];
        return resourceKey == null ? this.pickMiddleBiome(temperature, humidity, weirdness) : resourceKey;
    }

    private ResourceKey<Biome> pickRiverBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            if (CheckBiomeConfig.isBiomeEnabled(this.RIVER_BIOMES[temperature][humidity])) {
                return this.RIVER_BIOMES[temperature][humidity];
            }
            return this.VANILLA_RIVER_BIOMES[temperature][humidity];
        }
        if (this.RIVER_BIOMES_VARIANT[temperature][humidity] == null) {
            if (CheckBiomeConfig.isBiomeEnabled(this.RIVER_BIOMES[temperature][humidity])) {
                return this.RIVER_BIOMES[temperature][humidity];
            }
            return this.VANILLA_RIVER_BIOMES[temperature][humidity];
        }
        if (CheckBiomeConfig.isBiomeEnabled(this.RIVER_BIOMES_VARIANT[temperature][humidity])) {
            return this.RIVER_BIOMES_VARIANT[temperature][humidity];
        }
        return this.VANILLA_RIVER_BIOMES_VARIANT[temperature][humidity];
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private void addBottomBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.1f), (Climate.Parameter)weirdness, (float)offset), biome));
    }
}

