/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators;

import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.ICDGKinetics;
import com.jesz.createdieselgenerators.commands.CDGCommands;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.items.ItemRegistry;
import com.jesz.createdieselgenerators.other.EntityTickEvent;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.brigadier.CommandDispatcher;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CKinetics;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="createdieselgenerators")
public class Events {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        new CDGCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)FuelTypeManager.ReloadListener.INSTANCE);
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent event) {
        ItemEntity itemEntity;
        Entity entity = event.entity;
        if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).m_32055_().m_150930_((Item)ItemRegistry.LIGHTER.get()) && ((Boolean)ConfigRegistry.COMBUSTIBLES_BLOW_UP.get()).booleanValue() && itemEntity.m_32055_().m_41783_() != null && itemEntity.m_32055_().m_41783_().m_128451_("Type") == 2) {
            FluidState fState = itemEntity.m_183503_().m_6425_(new BlockPos(itemEntity.m_20318_(1.0f)));
            if (fState.m_192917_((Fluid)Fluids.f_76193_) || fState.m_192917_((Fluid)Fluids.f_76192_)) {
                itemEntity.m_32055_().m_41783_().m_128405_("Type", 1);
                itemEntity.m_183503_().m_7785_(itemEntity.m_20318_((float)1.0f).f_82479_, itemEntity.m_20318_((float)1.0f).f_82480_, itemEntity.m_20318_((float)1.0f).f_82481_, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                return;
            }
            if (FuelTypeManager.getGeneratedSpeed(fState.m_76152_()) != 0.0f) {
                itemEntity.m_183503_().m_7703_(null, null, null, itemEntity.m_20318_((float)1.0f).f_82479_, itemEntity.m_20318_((float)1.0f).f_82480_, itemEntity.m_20318_((float)1.0f).f_82481_, 3.0f, true, Explosion.BlockInteraction.BREAK);
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent event) {
        Level level = event.getWorld();
        if (((Boolean)ConfigRegistry.COMBUSTIBLES_BLOW_UP.get()).booleanValue() && !level.f_46443_) {
            for (int x = -2; x < 2; ++x) {
                for (int y = -2; y < 2; ++y) {
                    for (int z = -2; z < 2; ++z) {
                        IFluidHandler tank;
                        BlockEntity be;
                        BlockPos pos = new BlockPos((double)x + event.getExplosion().getPosition().f_82479_, (double)y + event.getExplosion().getPosition().f_82480_, (double)z + event.getExplosion().getPosition().f_82481_);
                        if (!level.m_46739_(pos) || !(Math.abs(Math.sqrt(x * x + y * y + z * z)) < 2.0)) continue;
                        FluidState fluidState = level.m_6425_(pos);
                        if (FuelTypeManager.getGeneratedSpeed(fluidState.m_76152_()) != 0.0f) {
                            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                            try {
                                level.m_7703_(null, null, null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 3.0f, true, Explosion.BlockInteraction.BREAK);
                            }
                            catch (StackOverflowError stackOverflowError) {
                                // empty catch block
                            }
                        }
                        if ((be = level.m_7702_(pos)) == null || (tank = (IFluidHandler)be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null)) == null || FuelTypeManager.getGeneratedSpeed(tank.getFluidInTank(0).getFluid()) == 0.0f) continue;
                        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                        try {
                            level.m_7703_(null, null, null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 3.0f + (float)tank.getFluidInTank(0).getAmount() / 500.0f, true, Explosion.BlockInteraction.BREAK);
                            continue;
                        }
                        catch (StackOverflowError stackOverflowError) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void addTrade(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        if (event.getType() != VillagerProfession.f_35598_) {
            return;
        }
        ((List)trades.get(2)).add((t, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)ItemRegistry.LIGHTER.get()), 10, 8, 0.02f));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void addToItemTooltip(ItemTooltipEvent event) {
        BlockItem bi;
        Block currentSpeed2;
        if (!((Boolean)AllConfigs.client().tooltips.get()).booleanValue()) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        List tooltip = event.getToolTip();
        Item item = event.getItemStack().m_41720_();
        if ((item instanceof BucketItem || item instanceof MilkBucketItem) && ((Boolean)ConfigRegistry.FUEL_TOOLTIPS.get()).booleanValue()) {
            Fluid fluid = (Fluid)ForgeMod.MILK.get();
            if (item instanceof BucketItem) {
                BucketItem bi2 = (BucketItem)item;
                fluid = bi2.getFluid();
            }
            if (FuelTypeManager.getGeneratedSpeed(fluid) != 0.0f) {
                if (Screen.m_96639_()) {
                    tooltip.add(1, Components.translatable((String)"createdieselgenerators.tooltip.holdForFuelStats", (Object[])new Object[]{Components.translatable((String)"createdieselgenerators.tooltip.keyAlt").m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.DARK_GRAY));
                    tooltip.add(2, Components.immutableEmpty());
                    byte enginesEnabled = (byte)((DieselGeneratorBlock.EngineTypes.NORMAL.enabled() ? 1 : 0) + (DieselGeneratorBlock.EngineTypes.MODULAR.enabled() ? 1 : 0) + (DieselGeneratorBlock.EngineTypes.HUGE.enabled() ? 1 : 0));
                    int currentEngineIndex = AnimationTickHolder.getTicks() % 120 / 20;
                    List<DieselGeneratorBlock.EngineTypes> enabledEngines = Arrays.stream(DieselGeneratorBlock.EngineTypes.values()).filter(DieselGeneratorBlock.EngineTypes::enabled).toList();
                    DieselGeneratorBlock.EngineTypes currentEngine = enabledEngines.get(currentEngineIndex % enginesEnabled);
                    float currentSpeed2 = FuelTypeManager.getGeneratedSpeed(currentEngine, fluid);
                    float currentCapacity = FuelTypeManager.getGeneratedStress(currentEngine, fluid);
                    float currentBurn = FuelTypeManager.getBurnRate(currentEngine, fluid);
                    if (enginesEnabled != 1) {
                        tooltip.add(3, Components.translatable((String)("block.createdieselgenerators." + (currentEngine == DieselGeneratorBlock.EngineTypes.MODULAR ? "large_" : (currentEngine == DieselGeneratorBlock.EngineTypes.HUGE ? "huge_" : "")) + "diesel_engine")).m_130940_(ChatFormatting.GRAY));
                    }
                    tooltip.add(enginesEnabled != 1 ? 4 : 3, Components.translatable((String)"createdieselgenerators.tooltip.fuelSpeed", (Object[])new Object[]{Lang.number((double)currentSpeed2).component().m_130948_(TooltipHelper.Palette.STANDARD_CREATE.primary())}).m_130940_(ChatFormatting.DARK_GRAY));
                    tooltip.add(enginesEnabled != 1 ? 5 : 4, Components.translatable((String)"createdieselgenerators.tooltip.fuelStress", (Object[])new Object[]{Lang.number((double)currentCapacity).component().m_130948_(TooltipHelper.Palette.STANDARD_CREATE.primary())}).m_130940_(ChatFormatting.DARK_GRAY));
                    tooltip.add(enginesEnabled != 1 ? 6 : 5, Components.translatable((String)"createdieselgenerators.tooltip.fuelBurnRate", (Object[])new Object[]{Lang.number((double)currentBurn).component().m_130948_(TooltipHelper.Palette.STANDARD_CREATE.primary())}).m_130940_(ChatFormatting.DARK_GRAY));
                    tooltip.add(enginesEnabled != 1 ? 7 : 6, Components.immutableEmpty());
                } else {
                    tooltip.add(1, Components.translatable((String)"createdieselgenerators.tooltip.holdForFuelStats", (Object[])new Object[]{Components.translatable((String)"createdieselgenerators.tooltip.keyAlt").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
        }
        if (ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).m_135827_() != "createdieselgenerators") {
            return;
        }
        String path = "createdieselgenerators." + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).m_135815_();
        ArrayList<Object> tooltipList = new ArrayList<Object>();
        if (!Components.translatable((String)(path + ".tooltip.summary")).getString().equals(path + ".tooltip.summary")) {
            if (Screen.m_96638_()) {
                tooltipList.add(Lang.translateDirect((String)"tooltip.holdForDescription", (Object[])new Object[]{Components.translatable((String)"create.tooltip.keyShift").m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.DARK_GRAY));
                tooltipList.add(Components.immutableEmpty());
                tooltipList.addAll(TooltipHelper.cutStringTextComponent((String)Components.translatable((String)(path + ".tooltip.summary")).getString(), (TooltipHelper.Palette)TooltipHelper.Palette.STANDARD_CREATE));
                if (!Components.translatable((String)(path + ".tooltip.condition1")).getString().equals(path + ".tooltip.condition1")) {
                    tooltipList.add(Components.immutableEmpty());
                    tooltipList.add(Components.translatable((String)(path + ".tooltip.condition1")).m_130940_(ChatFormatting.GRAY));
                    tooltipList.addAll(TooltipHelper.cutStringTextComponent((String)Components.translatable((String)(path + ".tooltip.behaviour1")).getString(), (Style)TooltipHelper.Palette.STANDARD_CREATE.primary(), (Style)TooltipHelper.Palette.STANDARD_CREATE.highlight(), (int)1));
                    if (!Components.translatable((String)(path + ".tooltip.condition2")).getString().equals(path + ".tooltip.condition2")) {
                        tooltipList.add(Components.translatable((String)(path + ".tooltip.condition2")).m_130940_(ChatFormatting.GRAY));
                        tooltipList.addAll(TooltipHelper.cutStringTextComponent((String)Components.translatable((String)(path + ".tooltip.behaviour2")).getString(), (Style)TooltipHelper.Palette.STANDARD_CREATE.primary(), (Style)TooltipHelper.Palette.STANDARD_CREATE.highlight(), (int)1));
                    }
                }
            } else {
                tooltipList.add(Lang.translateDirect((String)"tooltip.holdForDescription", (Object[])new Object[]{Components.translatable((String)"create.tooltip.keyShift").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        tooltip.addAll(1, tooltipList);
        CKinetics config = AllConfigs.server().kinetics;
        if (item instanceof BlockItem && (currentSpeed2 = (bi = (BlockItem)item).m_40614_()) instanceof ICDGKinetics) {
            ICDGKinetics k = (ICDGKinetics)currentSpeed2;
            boolean hasGoggles = GogglesItem.isWearingGoggles((Player)event.getPlayer());
            if (k.getDefaultStressCapacity() != 0.0f) {
                float stressCapacity = k.getDefaultStressCapacity();
                float speed = k.getDefaultSpeed();
                tooltip.add(Components.immutableEmpty());
                tooltip.add(Components.translatable((String)"create.tooltip.capacityProvided").m_130940_(ChatFormatting.GRAY));
                MutableComponent component = (double)k.getDefaultStressCapacity() >= (Double)config.highCapacity.get() ? Components.literal((String)TooltipHelper.makeProgressBar((int)3, (int)3)).m_7220_((Component)(hasGoggles ? Components.empty() : Components.translatable((String)"create.tooltip.capacityProvided.high"))).m_130940_(IRotate.StressImpact.LOW.getAbsoluteColor()) : ((double)k.getDefaultStressCapacity() >= (Double)config.mediumCapacity.get() ? Components.literal((String)TooltipHelper.makeProgressBar((int)3, (int)2)).m_7220_((Component)(hasGoggles ? Components.empty() : Components.translatable((String)"create.tooltip.capacityProvided.medium"))).m_130940_(IRotate.StressImpact.MEDIUM.getAbsoluteColor()) : Components.literal((String)TooltipHelper.makeProgressBar((int)3, (int)1)).m_7220_((Component)(hasGoggles ? Components.empty() : Components.translatable((String)"create.tooltip.capacityProvided.low"))).m_130940_(IRotate.StressImpact.HIGH.getAbsoluteColor()));
                if (hasGoggles) {
                    tooltip.add(component.m_7220_((Component)Lang.number((double)(stressCapacity / speed)).text("x ").add(Lang.translate((String)"generic.unit.rpm", (Object[])new Object[0])).component()));
                    if (speed != 0.0f) {
                        tooltip.add(Components.literal((String)" -> ").m_7220_((Component)Lang.translate((String)"tooltip.up_to", (Object[])new Object[]{Lang.number((double)k.getDefaultStressCapacity())}).add(Lang.translate((String)"generic.unit.stress", (Object[])new Object[0])).component()).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                } else {
                    tooltip.add(component);
                }
            } else if (k.getDefaultStressStressImpact() != 0.0f) {
                tooltip.add(Components.immutableEmpty());
                tooltip.add(Components.translatable((String)"create.tooltip.stressImpact").m_130940_(ChatFormatting.GRAY));
                if ((double)k.getDefaultStressStressImpact() >= (Double)config.highStressImpact.get()) {
                    tooltip.add(Components.literal((String)TooltipHelper.makeProgressBar((int)3, (int)3)).m_7220_((Component)(hasGoggles ? Lang.number((double)k.getDefaultStressStressImpact()).add(Lang.text((String)"x ").add(Lang.translate((String)"generic.unit.rpm", (Object[])new Object[0]))).component() : Components.translatable((String)"create.tooltip.stressImpact.high"))).m_130940_(IRotate.StressImpact.HIGH.getAbsoluteColor()));
                } else if ((double)k.getDefaultStressStressImpact() >= (Double)config.mediumStressImpact.get()) {
                    tooltip.add(Components.literal((String)TooltipHelper.makeProgressBar((int)3, (int)2)).m_7220_((Component)(hasGoggles ? Lang.number((double)k.getDefaultStressStressImpact()).add(Lang.text((String)"x ").add(Lang.translate((String)"generic.unit.rpm", (Object[])new Object[0]))).component() : Components.translatable((String)"create.tooltip.stressImpact.medium"))).m_130940_(IRotate.StressImpact.MEDIUM.getAbsoluteColor()));
                } else {
                    tooltip.add(Components.literal((String)TooltipHelper.makeProgressBar((int)3, (int)1)).m_7220_((Component)(hasGoggles ? Lang.number((double)k.getDefaultStressStressImpact()).add(Lang.text((String)"x ").add(Lang.translate((String)"generic.unit.rpm", (Object[])new Object[0]))).component() : Components.translatable((String)"create.tooltip.stressImpact.low"))).m_130940_(IRotate.StressImpact.LOW.getAbsoluteColor()));
                }
            }
        }
    }
}

