/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks;

import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.ICDGKinetics;
import com.jesz.createdieselgenerators.blocks.entity.BlockEntityRegistry;
import com.jesz.createdieselgenerators.blocks.entity.LargeDieselGeneratorBlockEntity;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.items.ItemRegistry;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class LargeDieselGeneratorBlock
extends HorizontalKineticBlock
implements IBE<LargeDieselGeneratorBlockEntity>,
ISpecialBlockItemRequirement,
ICDGKinetics {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED_BEFORE = BooleanProperty.m_61465_((String)"last_powered");
    public static final BooleanProperty PIPE = BooleanProperty.m_61465_((String)"pipe");
    public static final BooleanProperty SILENCED = BooleanProperty.m_61465_((String)"silenced");
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public LargeDieselGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)PIPE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SILENCED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor level, BlockPos pos, BlockPos neighbourPos) {
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            if (be.getEngineBack() == null) {
                be.updateStacked();
            }
        });
        return super.m_7417_(state, direction, neighbourState, level, pos, neighbourPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemInHand = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!player.m_6144_() && player.m_36326_() && placementHelper.matchesItem(itemInHand)) {
            placementHelper.getOffset(player, level, state, pos, hit).placeInWorld(level, (BlockItem)itemInHand.m_41720_(), player, hand, hit);
            return InteractionResult.SUCCESS;
        }
        if (ItemRegistry.ENGINE_SILENCER.isIn(itemInHand)) {
            if (((Boolean)state.m_61143_((Property)SILENCED)).booleanValue()) {
                return InteractionResult.PASS;
            }
            if (!player.m_7500_()) {
                itemInHand.m_41774_(1);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SILENCED, (Comparable)Boolean.valueOf(true)), 3);
            this.playRotateSound(level, pos);
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)ConfigRegistry.ENGINES_FILLED_WITH_ITEMS.get()).booleanValue()) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        if (itemInHand.m_41619_()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SmartBlockEntity) {
            SmartBlockEntity be = (SmartBlockEntity)blockEntity;
            IFluidHandler tank = (IFluidHandler)be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
            if (tank == null) {
                return InteractionResult.PASS;
            }
            Item item = itemInHand.m_41720_();
            if (item instanceof BucketItem) {
                BucketItem bi = (BucketItem)item;
                if (!tank.getFluidInTank(0).isEmpty()) {
                    return InteractionResult.FAIL;
                }
                tank.fill(new FluidStack(bi.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResult.SUCCESS;
            }
            if (itemInHand.m_41720_() instanceof MilkBucketItem) {
                if (!tank.getFluidInTank(0).isEmpty()) {
                    return InteractionResult.FAIL;
                }
                tank.fill(new FluidStack((Fluid)ForgeMod.MILK.get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResult.SUCCESS;
            }
            IFluidHandlerItem itemTank = (IFluidHandlerItem)itemInHand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
            if (itemTank == null) {
                return InteractionResult.PASS;
            }
            itemTank.drain(tank.fill(itemTank.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_() == Direction.UP) {
            KineticBlockEntity.switchToBlockState((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (BlockState)this.updateAfterWrenched((BlockState)state.m_61124_((Property)PIPE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)PIPE) == false)), context));
            this.playRotateSound(context.m_43725_(), context.m_8083_());
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)SILENCED)).booleanValue() && context.m_43723_() != null && !context.m_43725_().f_46443_) {
            if (!context.m_43723_().m_7500_()) {
                context.m_43723_().m_150109_().m_150079_(ItemRegistry.ENGINE_SILENCER.asStack());
            }
            context.m_43725_().m_7731_(context.m_8083_(), (BlockState)state.m_61124_((Property)SILENCED, (Comparable)Boolean.valueOf(false)), 3);
            this.playRotateSound(context.m_43725_(), context.m_8083_());
            return InteractionResult.SUCCESS;
        }
        return super.onWrenched(state, context);
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return originalState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PIPE, SILENCED, DieselGeneratorBlock.POWERED});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        if (pContext.m_43723_().m_6144_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean moving) {
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            LargeDieselGeneratorBlockEntity front = (LargeDieselGeneratorBlockEntity)((Object)((Object)be.frontEngine.get()));
            if (front == null) {
                front = be;
            }
            if (front != be) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(level.m_46753_(pos))), 2);
            }
            if (!((Boolean)front.m_58900_().m_61143_((Property)DieselGeneratorBlock.POWERED)).booleanValue() && level.m_46753_(pos)) {
                level.m_7731_(front.m_58899_(), (BlockState)front.m_58900_().m_61124_((Property)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
            if (((Boolean)front.m_58900_().m_61143_((Property)DieselGeneratorBlock.POWERED)).booleanValue() && !level.m_46753_(pos)) {
                boolean atLeastOneEnginePowered = false;
                for (int i = 0; i < front.stacked; ++i) {
                    BlockState bs = level.m_8055_(pos.m_142629_(((Direction)state.m_61143_((Property)FACING)).m_122434_(), -i));
                    if (!(bs.m_60734_() instanceof LargeDieselGeneratorBlock) || ((Direction)bs.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() || !((Boolean)bs.m_61143_((Property)DieselGeneratorBlock.POWERED)).booleanValue()) continue;
                    atLeastOneEnginePowered = true;
                    break;
                }
                if (!atLeastOneEnginePowered) {
                    level.m_7731_(front.m_58899_(), (BlockState)front.m_58900_().m_61124_((Property)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(false)), 2);
                }
            }
        });
        super.m_6861_(state, level, pos, block, otherPos, moving);
    }

    public Class<LargeDieselGeneratorBlockEntity> getBlockEntityClass() {
        return LargeDieselGeneratorBlockEntity.class;
    }

    public BlockEntityType<? extends LargeDieselGeneratorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockEntityRegistry.LARGE_DIESEL_ENGINE.get();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_((Property)FACING) == Direction.NORTH || pState.m_61143_((Property)FACING) == Direction.SOUTH) {
            return Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)-2.0, (double)0.0, (double)0.0, (double)18.0, (double)4.0, (double)16.0));
        }
        return Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)-2.0, (double)16.0, (double)4.0, (double)18.0));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == face.m_122434_();
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.m_61143_((Property)FACING)).m_122434_();
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(BlockRegistry.MODULAR_DIESEL_ENGINE.asStack());
        if (((Boolean)state.m_61143_((Property)SILENCED)).booleanValue()) {
            list.add(ItemRegistry.ENGINE_SILENCER.asStack());
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, list);
    }

    @Override
    public float getDefaultStressCapacity() {
        return 2048.0f;
    }

    @Override
    public float getDefaultStressStressImpact() {
        return 0.0f;
    }

    @Override
    public float getDefaultSpeed() {
        return 96.0f;
    }

    private static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(arg_0 -> BlockRegistry.MODULAR_DIESEL_ENGINE.has(arg_0), state -> ((Direction)state.m_61143_((Property)FACING)).m_122434_(), (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> BlockRegistry.MODULAR_DIESEL_ENGINE.isIn(arg_0);
        }
    }
}

