/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.ct;

import com.jesz.createdieselgenerators.blocks.ct.DistillationTankCTBehavior;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.block.connected.CTModel;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class DistillationTankModel
extends CTModel {
    protected static final ModelProperty<CullData> CULL_PROPERTY = new ModelProperty();

    public DistillationTankModel(BakedModel originalModel) {
        super(originalModel, (ConnectedTextureBehaviour)new DistillationTankCTBehavior());
    }

    protected void gatherModelData(ModelDataMap.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData blockEntityData) {
        super.gatherModelData(builder, world, pos, state, blockEntityData);
        CullData cullData = new CullData();
        for (Direction d : Iterate.horizontalDirections) {
            cullData.setCulled(d, ConnectivityHandler.isConnected((BlockGetter)world, (BlockPos)pos, (BlockPos)pos.m_142300_(d)));
        }
        builder.withInitial(CULL_PROPERTY, (Object)cullData);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        if (side != null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction d : Iterate.directions) {
            if (extraData.hasProperty(CULL_PROPERTY) && ((CullData)extraData.getData(CULL_PROPERTY)).isCulled(d)) continue;
            quads.addAll(super.getQuads(state, d, rand, extraData));
        }
        quads.addAll(super.getQuads(state, null, rand, extraData));
        return quads;
    }

    private static class CullData {
        boolean[] culledFaces = new boolean[4];

        public CullData() {
            Arrays.fill(this.culledFaces, false);
        }

        void setCulled(Direction face, boolean cull) {
            if (face.m_122434_().m_122478_()) {
                return;
            }
            this.culledFaces[face.m_122416_()] = cull;
        }

        boolean isCulled(Direction face) {
            if (face.m_122434_().m_122478_()) {
                return false;
            }
            return this.culledFaces[face.m_122416_()];
        }
    }
}

