/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.entity.DieselGeneratorValueBox;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.jesz.createdieselgenerators.sounds.SoundRegistry;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class DieselGeneratorBlockEntity
extends GeneratingKineticBlockEntity {
    BlockState state;
    public boolean validFuel;
    public SmartFluidTankBehaviour tank;
    int partialSecond;
    public AbstractComputerBehaviour computerBehaviour;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    int t = 0;

    public DieselGeneratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.state = state;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        if (this.state.m_61143_((Property)DieselGeneratorBlock.FACING) == Direction.DOWN) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == Direction.WEST) {
                return this.tank.getCapability().cast();
            }
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == Direction.EAST) {
                return this.tank.getCapability().cast();
            }
        } else if (this.state.m_61143_((Property)DieselGeneratorBlock.FACING) == Direction.UP) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == Direction.NORTH) {
                return this.tank.getCapability().cast();
            }
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == Direction.SOUTH) {
                return this.tank.getCapability().cast();
            }
        } else if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == Direction.DOWN) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("PartialSecond", this.partialSecond);
        this.tank.write(compound, false);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.partialSecond = compound.m_128451_("PartialSecond");
        this.tank.read(compound, false);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)Lang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new DieselGeneratorValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void onDirectionChanged() {
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float calculateAddedStressCapacity() {
        if (this.getGeneratedSpeed() == 0.0f || ((Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.POWERED)).booleanValue()) {
            return 0.0f;
        }
        return FuelTypeManager.getGeneratedStress((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) / Math.abs(this.getGeneratedSpeed());
    }

    public float getGeneratedSpeed() {
        if (((Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.POWERED)).booleanValue()) {
            return 0.0f;
        }
        return DieselGeneratorBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * FuelTypeManager.getGeneratedSpeed((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid())), (Direction)((Direction)this.m_58900_().m_61143_((Property)DieselGeneratorBlock.FACING))) * ((Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.TURBOCHARGED) != false ? ((Double)ConfigRegistry.TURBOCHARGED_ENGINE_MULTIPLIER.get()).floatValue() : 1.0f);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!IRotate.StressImpact.isEnabled()) {
            return added;
        }
        float stressBase = this.calculateAddedStressCapacity();
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return added;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability().cast());
    }

    public void tick() {
        super.tick();
        this.state = this.m_58900_();
        this.reActivateSource = true;
        if (this.f_58857_.f_46443_ && !((Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.SILENCED)).booleanValue()) {
            if ((Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.TURBOCHARGED) != false ? this.t > FuelTypeManager.getSoundSpeed(this.tank.getPrimaryHandler().getFluid().getFluid()) / 2 : this.t > FuelTypeManager.getSoundSpeed(this.tank.getPrimaryHandler().getFluid().getFluid())) {
                if (this.validFuel) {
                    this.t = 0;
                    this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (SoundEvent)SoundRegistry.DIESEL_ENGINE_SOUND.get(), SoundSource.BLOCKS, (Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.TURBOCHARGED) != false ? 0.5f : 0.3f, (Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.TURBOCHARGED) != false ? 1.1f : 1.0f, false);
                }
            } else {
                ++this.t;
            }
        }
        this.validFuel = (Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.POWERED) != false ? false : FuelTypeManager.getGeneratedSpeed((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) != 0.0f;
        ++this.partialSecond;
        if (this.partialSecond >= 20) {
            this.partialSecond = 0;
            if (this.validFuel) {
                float f = this.tank.getPrimaryHandler().getFluid().getAmount();
                float f2 = FuelTypeManager.getBurnRate((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid());
                float f3 = (Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.TURBOCHARGED) == false ? 1.0f : ((Double)ConfigRegistry.TURBOCHARGED_ENGINE_BURN_RATE_MULTIPLIER.get()).floatValue();
                if (f >= f2 * f3) {
                    this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)this.tank.getPrimaryHandler().getFluid(), (int)((int)((float)this.tank.getPrimaryHandler().getFluid().getAmount() - (float)FuelTypeManager.getBurnRate((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) * ((Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.TURBOCHARGED) == false ? 1.0f : ((Double)ConfigRegistry.TURBOCHARGED_ENGINE_BURN_RATE_MULTIPLIER.get()).floatValue())))));
                } else {
                    this.tank.getPrimaryHandler().setFluid(FluidStack.EMPTY);
                }
            }
        }
    }
}

