/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.OilBarrelBlock;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class OilBarrelBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Fluid,
IHaveGoggleInformation {
    private static final int MAX_SIZE = 3;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    protected FluidTank tankInventory = this.createInventory();
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected int width = 1;
    protected int height = 1;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;

    public OilBarrelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.refreshCapability();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(OilBarrelBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_142082_(xOffset, yOffset, zOffset);
                    OilBarrelBlockEntity tankAt = (OilBarrelBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.m_58903_(), (BlockGetter)this.f_58857_, (BlockPos)pos);
                    if (tankAt == null) continue;
                    this.f_58857_.m_46717_(pos, tankAt.m_58900_().m_60734_());
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public OilBarrelBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof OilBarrelBlockEntity) {
            return (OilBarrelBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * OilBarrelBlockEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    public void removeController(boolean keepFluids) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        OilBarrelBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerBE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * OilBarrelBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(OilBarrelBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.m_128379_("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return (Direction.Axis)this.m_58900_().m_61143_(OilBarrelBlock.AXIS);
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return width * 4;
    }

    public int getMaxWidth() {
        return (Integer)ConfigRegistry.MAX_OIL_BARREL_WIDTH.get();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return OilBarrelBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }
}

