/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.entity.PumpjackBearingBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.PumpjackCrankValueBox;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Components;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PumpjackCrankBlockEntity
extends KineticBlockEntity {
    public float angle = 0.0f;
    public float prevAngle = 0.0f;
    public float bearingAngle;
    public float prevBearingAngle;
    public BlockPos bearingPos;
    public WeakReference<PumpjackBearingBlockEntity> bearing = new WeakReference<Object>(null);
    public Vec3 crankBearingLocation = new Vec3(0.0, -100.0, 0.0);
    public ScrollOptionBehaviour<CrankSize> crankSize;

    public PumpjackCrankBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.angle = compound.m_128457_("Angle");
        this.crankBearingLocation = new Vec3(compound.m_128459_("BackPosX"), compound.m_128459_("BackPosY"), compound.m_128459_("BackPosZ"));
        super.read(compound, clientPacket);
    }

    public void handleUpdateTag(CompoundTag compound) {
        this.angle = compound.m_128457_("Angle");
        this.crankBearingLocation = new Vec3(compound.m_128459_("BackPosX"), compound.m_128459_("BackPosY"), compound.m_128459_("BackPosZ"));
        super.handleUpdateTag(compound);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        compound.m_128350_("Angle", this.angle);
        compound.m_128347_("BackPosX", this.crankBearingLocation.f_82479_);
        compound.m_128347_("BackPosY", this.crankBearingLocation.f_82480_);
        compound.m_128347_("BackPosZ", this.crankBearingLocation.f_82481_);
        return compound;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("Angle", this.angle);
        compound.m_128347_("BackPosX", this.crankBearingLocation.f_82479_);
        compound.m_128347_("BackPosY", this.crankBearingLocation.f_82480_);
        compound.m_128347_("BackPosZ", this.crankBearingLocation.f_82481_);
        super.write(compound, clientPacket);
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = 16.0f;
        return impact;
    }

    public PumpjackBearingBlockEntity getBearing() {
        if (this.bearing.get() != null) {
            if (((PumpjackBearingBlockEntity)((Object)this.bearing.get())).m_58901_() || !((PumpjackBearingBlockEntity)((Object)this.bearing.get())).isRunning()) {
                this.bearing = new WeakReference<Object>(null);
                return null;
            }
            return (PumpjackBearingBlockEntity)((Object)this.bearing.get());
        }
        return null;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(3.0);
    }

    public void tick() {
        super.tick();
        PumpjackBearingBlockEntity bearing = this.getBearing();
        if (bearing != null && bearing.isStalled()) {
            return;
        }
        this.prevAngle = this.angle;
        if (this.angle >= 359.0f || this.angle <= -359.0f) {
            this.angle = 0.0f;
        }
        if (this.getSpeed() != 0.0f) {
            this.angle += Mth.m_14036_((float)Math.abs(this.getSpeed()), (float)0.0f, (float)64.0f) / 10.0f;
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.crankSize = new ScrollOptionBehaviour(CrankSize.class, (Component)Components.translatable((String)"createdieselgenerators.pumpjack_crank.crank_size"), (SmartBlockEntity)this, (ValueBoxTransform)new PumpjackCrankValueBox());
        this.crankSize.withCallback($ -> this.onSizeChanged());
        behaviours.add((BlockEntityBehaviour)this.crankSize);
        super.addBehaviours(behaviours);
    }

    private void onSizeChanged() {
    }

    public static enum CrankSize implements INamedIconOptions
    {
        NORMAL(AllIcons.I_CLEAR),
        LARGE(AllIcons.I_PLACE);

        private final AllIcons icon;

        private CrankSize(AllIcons icon) {
            this.icon = icon;
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return "tooltip.capacityProvided." + (this.icon == AllIcons.I_CLEAR ? "low" : "high");
        }
    }
}

