/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.commands;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.world.OilChunksSavedData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.foundation.utility.Components;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;

public class CDGCommands {
    public CDGCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"cdg").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"oil").then(Commands.m_82127_((String)"get").executes(command -> this.getOilChunk((CommandSourceStack)command.getSource())))).then(Commands.m_82127_((String)"locate").executes(command -> this.locateOilChunk((CommandSourceStack)command.getSource())))).then(Commands.m_82127_((String)"regenerate").executes(command -> this.refreshOilChunk((CommandSourceStack)command.getSource())))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100000)).executes(command -> this.setOilChunk((CommandSourceStack)command.getSource(), (CommandContext<CommandSourceStack>)command))))));
    }

    private int getOilChunk(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.m_6761_(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos(source.m_81371_()));
        int amount = CreateDieselGenerators.getOilAmount((Holder<Biome>)source.m_81372_().m_204166_(new BlockPos(chunkPos.f_45578_ * 16, 64, chunkPos.f_45579_ * 16)), chunkPos.f_45578_, chunkPos.f_45579_, source.m_81372_().m_7328_());
        OilChunksSavedData sd = OilChunksSavedData.load(source.m_81372_());
        if (sd.getChunkOilAmount(chunkPos) != -1) {
            amount = sd.getChunkOilAmount(chunkPos);
        }
        source.m_81354_((Component)Components.literal((String)"There is ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Components.literal((String)(amount + "B")).m_130940_(ChatFormatting.GOLD)).m_130946_(" of Oil in this Chunk.").m_130940_(ChatFormatting.GRAY), false);
        return 1;
    }

    private int refreshOilChunk(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.m_6761_(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos(source.m_81371_()));
        OilChunksSavedData sd = OilChunksSavedData.load(source.m_81372_());
        sd.removeChunkAmount(chunkPos);
        source.m_81354_((Component)Components.literal((String)"Refreshed this chunks oil contents").m_130940_(ChatFormatting.GRAY), false);
        return 1;
    }

    private int setOilChunk(CommandSourceStack source, CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (!source.m_6761_(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos(source.m_81371_()));
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        OilChunksSavedData sd = OilChunksSavedData.load(source.m_81372_());
        sd.setChunkAmount(chunkPos, amount);
        source.m_81354_((Component)Components.literal((String)"Set this chunk's oil deposits to  ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Components.literal((String)(amount + "B")).m_130940_(ChatFormatting.GOLD)), false);
        return 1;
    }

    private int locateOilChunk(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.m_6761_(2)) {
            return 0;
        }
        HashMap<ChunkPos, Integer> oilChunks = new HashMap<ChunkPos, Integer>();
        for (int x = -10; x < 10; ++x) {
            for (int z = -10; z < 10; ++z) {
                ChunkPos chunkPos = new ChunkPos(new BlockPos(source.m_81371_()));
                chunkPos = new ChunkPos(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z);
                OilChunksSavedData sd = OilChunksSavedData.load(source.m_81372_());
                int amount = sd.getChunkOilAmount(chunkPos);
                if (amount == -1) {
                    amount = CreateDieselGenerators.getOilAmount((Holder<Biome>)source.m_81372_().m_204166_(new BlockPos(chunkPos.f_45578_ * 16, 64, chunkPos.f_45579_ * 16)), chunkPos.f_45578_, chunkPos.f_45579_, source.m_81372_().m_7328_());
                }
                if (amount == 0) continue;
                oilChunks.put(chunkPos, amount);
            }
        }
        AtomicInteger closestAmount = new AtomicInteger(0);
        AtomicInteger closestX = new AtomicInteger(0);
        AtomicInteger closestZ = new AtomicInteger(0);
        AtomicReference<Float> closestDst = new AtomicReference<Float>(Float.valueOf(10000.0f));
        oilChunks.forEach((k, v) -> {
            float dst = (float)Math.sqrt(Math.abs(source.m_81371_().f_82479_ / 16.0 - (double)k.f_45578_) * Math.abs(source.m_81371_().f_82479_ / 16.0 - (double)k.f_45578_) + Math.abs(source.m_81371_().f_82481_ / 16.0 - (double)k.f_45579_) * Math.abs(source.m_81371_().f_82481_ / 16.0 - (double)k.f_45579_));
            if (dst < ((Float)closestDst.get()).floatValue()) {
                closestDst.set(Float.valueOf(dst));
                closestX.set(k.f_45578_);
                closestZ.set(k.f_45579_);
                closestAmount.set((int)v);
            }
        });
        if (closestAmount.get() != 0) {
            int finalX = closestX.get();
            int finalZ = closestZ.get();
            source.m_81354_((Component)Components.literal((String)"There is oil in the chunk ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Components.literal((String)(finalX + " " + finalZ)).m_130940_(ChatFormatting.GOLD).m_130938_(a -> a.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + finalX * 16 + " ~ " + finalZ * 16)))).m_130946_(" with ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Components.literal((String)(closestAmount + "B ")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Components.literal((String)"of oil.").m_130940_(ChatFormatting.GRAY)), false);
            return 1;
        }
        source.m_81352_((Component)Components.literal((String)"There is no oil chunk nearby").m_130940_(ChatFormatting.RED));
        return 1;
    }
}

