/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.items;

import com.jesz.createdieselgenerators.blocks.OilBarrelBlock;
import com.jesz.createdieselgenerators.blocks.entity.BlockEntityRegistry;
import com.jesz.createdieselgenerators.blocks.entity.OilBarrelBlockEntity;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class OilBarrelBlockItem
extends BlockItem {
    public OilBarrelBlockItem(Block p_40565_, Item.Properties p_40566_) {
        super(p_40565_, p_40566_);
    }

    public InteractionResult m_40576_(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.m_40576_(ctx);
        if (!initialResult.m_19077_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean m_7274_(BlockPos p_195943_1_, Level p_195943_2_, Player p_195943_3_, ItemStack p_195943_4_, BlockState p_195943_5_) {
        MinecraftServer minecraftserver = p_195943_2_.m_142572_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag nbt = p_195943_4_.m_41737_("BlockEntityTag");
        if (nbt != null) {
            FluidStack fluid;
            nbt.m_128473_("Size");
            nbt.m_128473_("Height");
            nbt.m_128473_("Controller");
            nbt.m_128473_("LastKnownPos");
            if (nbt.m_128441_("TankContent") && !(fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("TankContent"))).isEmpty()) {
                fluid.setAmount(Math.min(OilBarrelBlockEntity.getCapacityMultiplier(), fluid.getAmount()));
                nbt.m_128365_("TankContent", (Tag)fluid.writeToNBT(new CompoundTag()));
            }
        }
        return super.m_7274_(p_195943_1_, p_195943_2_, p_195943_3_, p_195943_4_, p_195943_5_);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.m_43723_();
        if (player == null) {
            return;
        }
        if (player.m_20161_()) {
            return;
        }
        Direction face = ctx.m_43719_();
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        BlockState placedOnState = world.m_8055_(placedOnPos = (pos = ctx.m_8083_()).m_142300_(face.m_122424_()));
        if (!(placedOnState.m_60734_() instanceof OilBarrelBlock)) {
            return;
        }
        OilBarrelBlockEntity tankAt = (OilBarrelBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)BlockEntityRegistry.OIL_BARREL.get()), (BlockGetter)world, (BlockPos)placedOnPos);
        if (tankAt == null) {
            return;
        }
        OilBarrelBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = controllerBE.getWidth();
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        Direction.Axis barrelBlockAxis = (Direction.Axis)placedOnState.m_61143_(OilBarrelBlock.AXIS);
        if (face.m_122434_() != barrelBlockAxis) {
            return;
        }
        Direction barrelFacing = Direction.m_122387_((Direction.Axis)barrelBlockAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos blockPos = startPos = face == barrelFacing.m_122424_() ? controllerBE.m_58899_().m_142300_(barrelFacing.m_122424_()) : controllerBE.m_58899_().m_5484_(barrelFacing, controllerBE.getHeight());
        if (VecHelper.getCoordinate((Vec3i)startPos, (Direction.Axis)barrelBlockAxis) != VecHelper.getCoordinate((Vec3i)pos, (Direction.Axis)barrelBlockAxis)) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = barrelBlockAxis == Direction.Axis.X ? startPos.m_142082_(0, xOffset, zOffset) : (barrelBlockAxis == Direction.Axis.Y ? startPos.m_142082_(xOffset, 0, zOffset) : startPos.m_142082_(xOffset, zOffset, 0));
                blockState = world.m_8055_(offsetPos);
                if (blockState.m_60734_() instanceof OilBarrelBlock) continue;
                if (!blockState.m_60767_().m_76336_()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = barrelBlockAxis == Direction.Axis.X ? startPos.m_142082_(0, xOffset, zOffset) : (barrelBlockAxis == Direction.Axis.Y ? startPos.m_142082_(xOffset, 0, zOffset) : startPos.m_142082_(xOffset, zOffset, 0));
                blockState = world.m_8055_(offsetPos);
                if (blockState.m_60734_() instanceof OilBarrelBlock) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().m_128379_("SilenceTankSound", true);
                super.m_40576_(context);
                player.getPersistentData().m_128473_("SilenceTankSound");
            }
        }
    }
}

