/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.altar;

import iskallia.vault.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RequiredItems
implements INBTSerializable<CompoundTag> {
    private String poolId;
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private int currentAmount;
    private int amountRequired;

    public RequiredItems(String poolId, List<ItemStack> items, int amountRequired) {
        this.poolId = poolId;
        this.items.addAll(items);
        this.amountRequired = amountRequired;
    }

    public RequiredItems(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public RequiredItems(String poolId, List<ItemStack> items, int currentAmount, int amountRequired) {
        this.poolId = poolId;
        this.items.addAll(items);
        this.currentAmount = currentAmount;
        this.amountRequired = amountRequired;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("poolId", this.poolId == null ? UUID.randomUUID().toString() : this.poolId);
        NBTHelper.writeCollection(nbt, "items", this.items, CompoundTag.class, IForgeItemStack::serializeNBT);
        nbt.m_128405_("currentAmount", this.getCurrentAmount());
        nbt.m_128405_("amountRequired", this.getAmountRequired());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.poolId = nbt.m_128441_("poolId") ? nbt.m_128461_("poolId") : UUID.randomUUID().toString();
        if (nbt.m_128441_("items")) {
            this.items.addAll(NBTHelper.readList(nbt, "items", CompoundTag.class, ItemStack::m_41712_));
        }
        if (nbt.m_128441_("item")) {
            this.items.add(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item")));
        }
        this.currentAmount = nbt.m_128451_("currentAmount");
        this.amountRequired = nbt.m_128451_("amountRequired");
    }

    public void addStack(ItemStack stack) {
        this.items.add(stack);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public boolean containsItem(ResourceLocation itemId) {
        return this.getItems().stream().map(ItemStack::m_41720_).map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).anyMatch(id -> id.equals((Object)itemId));
    }

    public int getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(int currentAmount) {
        this.currentAmount = currentAmount;
    }

    public void addAmount(int amount) {
        this.currentAmount += amount;
    }

    public int getAmountRequired() {
        return this.amountRequired;
    }

    public void setAmountRequired(int amountRequired) {
        this.amountRequired = amountRequired;
    }

    public boolean isComplete() {
        return this.getCurrentAmount() >= this.getAmountRequired();
    }

    public int getRemainder(int amount) {
        return Math.max(this.getCurrentAmount() + amount - this.getAmountRequired(), 0);
    }

    public RequiredItems copy() {
        return new RequiredItems(this.poolId, this.items, this.currentAmount, this.amountRequired);
    }

    public String getPoolId() {
        return this.poolId;
    }
}

