/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import iskallia.vault.antique.condition.AntiqueCondition;
import iskallia.vault.antique.condition.DropConditionContext;
import iskallia.vault.antique.condition.DropEntityConditionContext;
import iskallia.vault.init.ModConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class AntiqueConditionEntityGroup
extends AntiqueCondition {
    private final List<ResourceLocation> groups = new ArrayList<ResourceLocation>();

    @Override
    public boolean test(DropConditionContext context) {
        if (!(context instanceof DropEntityConditionContext)) {
            return false;
        }
        DropEntityConditionContext entityContext = (DropEntityConditionContext)context;
        LivingEntity entity = entityContext.getEntity();
        for (ResourceLocation group : this.groups) {
            if (ModConfigs.ENTITY_GROUPS.isInGroup(group, (Entity)entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void deserialize(JsonDeserializationContext ctx, JsonObject json) {
        if (!json.has("group")) {
            throw new JsonSyntaxException("Missing group, expected to find a string or array");
        }
        JsonElement typeElement = json.get("group");
        ArrayList<String> groups = new ArrayList<String>();
        if (typeElement.isJsonArray()) {
            for (JsonElement element : typeElement.getAsJsonArray()) {
                if (!element.isJsonPrimitive()) {
                    throw new JsonSyntaxException("Expected group to be a string, was " + String.valueOf(element));
                }
                groups.add(element.getAsString());
            }
        } else if (typeElement.isJsonPrimitive()) {
            groups.add(typeElement.getAsString());
        } else {
            throw new JsonSyntaxException("Expected group to be a string or an array of strings, was " + String.valueOf(typeElement));
        }
        for (String group : groups) {
            ResourceLocation groupKey = ResourceLocation.m_135820_((String)group);
            if (groupKey == null) {
                throw new JsonSyntaxException("Invalid resource location '" + group + "'");
            }
            this.groups.add(groupKey);
        }
    }

    @Override
    public JsonObject serialize(JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        this.groups.forEach(key -> array.add((JsonElement)new JsonPrimitive(key.toString())));
        json.add("group", (JsonElement)array);
        return json;
    }
}

