/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import iskallia.vault.antique.condition.AntiqueCondition;
import iskallia.vault.antique.condition.DropConditionContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class AntiqueConditionKey
extends AntiqueCondition {
    private final List<ResourceLocation> keys = new ArrayList<ResourceLocation>();

    @Override
    public boolean test(DropConditionContext context) {
        return this.keys.contains(context.getOwnerKey());
    }

    @Override
    public void deserialize(JsonDeserializationContext ctx, JsonObject json) {
        if (!json.has("key")) {
            throw new JsonSyntaxException("Missing key, expected to find a string or array");
        }
        JsonElement typeElement = json.get("key");
        if (typeElement.isJsonArray()) {
            for (JsonElement element : typeElement.getAsJsonArray()) {
                if (!element.isJsonPrimitive()) {
                    throw new JsonSyntaxException("Expected type to be a string, was " + String.valueOf(element));
                }
                ResourceLocation key = ResourceLocation.m_135820_((String)element.getAsString());
                if (key == null) {
                    throw new JsonSyntaxException("Expected type to be a valid ResourceLocation, was " + String.valueOf(element));
                }
                this.keys.add(key);
            }
        } else if (typeElement.isJsonPrimitive()) {
            ResourceLocation key = ResourceLocation.m_135820_((String)typeElement.getAsString());
            if (key == null) {
                throw new JsonSyntaxException("Expected type to be a valid ResourceLocation, was " + String.valueOf(typeElement));
            }
            this.keys.add(key);
        } else {
            throw new JsonSyntaxException("Expected type to be a string or an array of strings, was " + String.valueOf(typeElement));
        }
    }

    @Override
    public JsonObject serialize(JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        this.keys.forEach(key -> array.add(key.toString()));
        json.add("key", (JsonElement)array);
        return json;
    }
}

