/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import iskallia.vault.antique.condition.AntiqueCondition;
import iskallia.vault.antique.condition.DropConditionContext;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.data.item.ItemPredicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class AntiqueConditionPlayerHasItem
extends AntiqueCondition {
    private final List<ItemPredicate> predicates = new ArrayList<ItemPredicate>();

    @Override
    public boolean test(DropConditionContext context) {
        ServerPlayer player = context.getPlayer();
        if (player == null) {
            return false;
        }
        for (ItemPredicate pred : this.predicates) {
            if (!this.hasItem(player, pred)) continue;
            return true;
        }
        return false;
    }

    private boolean hasItem(final ServerPlayer player, ItemPredicate pred) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(){
            {
                this.addAll(player.m_150109_().f_35974_);
                this.addAll(player.m_150109_().f_35975_);
                this.addAll(player.m_150109_().f_35976_);
            }
        };
        for (ItemStack stack : items) {
            if (stack.m_41619_() || !pred.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JsonObject serialize(JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        this.predicates.forEach(itemPredicate -> Adapters.ITEM_PREDICATE.writeJson((ItemPredicate)itemPredicate).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0)));
        json.add("item", (JsonElement)array);
        return json;
    }

    @Override
    public void deserialize(JsonDeserializationContext ctx, JsonObject json) {
        if (!json.has("item")) {
            return;
        }
        JsonArray array = json.getAsJsonArray("item");
        for (int i = 0; i < array.size(); ++i) {
            JsonElement itemJson = array.get(i);
            Adapters.ITEM_PREDICATE.readJson(itemJson).ifPresent(this.predicates::add);
        }
    }

    public void addItemPredicate(ItemPredicate of) {
        if (of != null) {
            this.predicates.add(of);
        }
    }
}

