/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import iskallia.vault.antique.condition.AntiqueCondition;
import iskallia.vault.antique.condition.DropConditionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class AntiqueConditionTag
extends AntiqueCondition {
    private final List<String> tags = new ArrayList<String>();

    public void addTag(String ... tag) {
        Collections.addAll(this.tags, tag);
    }

    @Override
    public boolean test(DropConditionContext context) {
        return new HashSet<String>(context.getTags()).containsAll(this.tags);
    }

    @Override
    public void deserialize(JsonDeserializationContext ctx, JsonObject json) {
        if (!json.has("tag")) {
            throw new JsonSyntaxException("Missing tag, expected to find a string or array");
        }
        JsonElement typeElement = json.get("tag");
        if (typeElement.isJsonArray()) {
            for (JsonElement element : typeElement.getAsJsonArray()) {
                if (!element.isJsonPrimitive()) {
                    throw new JsonSyntaxException("Expected tag to be a string, was " + String.valueOf(element));
                }
                this.tags.add(element.getAsString());
            }
        } else if (typeElement.isJsonPrimitive()) {
            this.tags.add(typeElement.getAsString());
        } else {
            throw new JsonSyntaxException("Expected tag to be a string or an array of strings, was " + String.valueOf(typeElement));
        }
    }

    @Override
    public JsonObject serialize(JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        this.tags.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        json.add("tag", (JsonElement)array);
        return json;
    }
}

