/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import iskallia.vault.antique.condition.AntiqueCondition;
import iskallia.vault.antique.condition.DropConditionContext;
import iskallia.vault.antique.condition.DropConditionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AntiqueConditionType
extends AntiqueCondition {
    private final List<DropConditionType> types = new ArrayList<DropConditionType>();

    public void addType(DropConditionType ... type) {
        Collections.addAll(this.types, type);
    }

    @Override
    public boolean test(DropConditionContext context) {
        return this.types.contains((Object)context.getType());
    }

    @Override
    public void deserialize(JsonDeserializationContext ctx, JsonObject json) {
        if (!json.has("types")) {
            throw new JsonSyntaxException("Missing type, expected to find a string");
        }
        JsonElement typeElement = json.get("types");
        ArrayList<String> types = new ArrayList<String>();
        if (typeElement.isJsonArray()) {
            for (JsonElement element : typeElement.getAsJsonArray()) {
                if (!element.isJsonPrimitive()) {
                    throw new JsonSyntaxException("Expected type to be a string, was " + String.valueOf(element));
                }
                types.add(element.getAsString());
            }
        } else if (typeElement.isJsonPrimitive()) {
            types.add(typeElement.getAsString());
        } else {
            throw new JsonSyntaxException("Expected type to be a string or an array of strings, was " + String.valueOf(typeElement));
        }
        for (String type : types) {
            DropConditionType conditionType = DropConditionType.byName(type);
            if (conditionType == null) {
                throw new JsonSyntaxException("Unknown type '" + type + "'");
            }
            this.types.add(conditionType);
        }
    }

    @Override
    public JsonObject serialize(JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        this.types.forEach(type -> array.add((JsonElement)new JsonPrimitive(type.name())));
        json.add("types", (JsonElement)array);
        return json;
    }
}

