/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.condition;

import iskallia.vault.antique.condition.DropConditionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class DropConditionContext {
    private final int level;
    private final DropConditionType type;
    private final ResourceLocation ownerKey;
    private final List<String> tags = new ArrayList<String>();
    @Nullable
    private final ServerPlayer player;

    public DropConditionContext(int level, DropConditionType type, ResourceLocation ownerKey) {
        this(level, type, ownerKey, null);
    }

    public DropConditionContext(int level, DropConditionType type, ResourceLocation ownerKey, @Nullable ServerPlayer player) {
        this.level = level;
        this.type = type;
        this.ownerKey = ownerKey;
        this.player = player;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addTags(List<String> tags) {
        this.tags.addAll(tags);
    }

    public ResourceLocation getOwnerKey() {
        return this.ownerKey;
    }

    public List<String> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public int getLevel() {
        return this.level;
    }

    public DropConditionType getType() {
        return this.type;
    }

    @Nullable
    public ServerPlayer getPlayer() {
        return this.player;
    }
}

