/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.condition;

import iskallia.vault.antique.condition.DropConditionContext;
import iskallia.vault.antique.condition.DropConditionType;
import iskallia.vault.antique.condition.DropEntityConditionContext;
import iskallia.vault.block.entity.base.TemplateTagContainer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class DropConditionContextFactory {
    public static <T extends BlockEntity> DropConditionContext makeLootableContext(int level, T tile) {
        return DropConditionContextFactory.makeLootableContext(level, tile, null);
    }

    public static <T extends BlockEntity> DropConditionContext makeLootableContext(int level, T tile, @Nullable ServerPlayer player) {
        DropConditionContext context = new DropConditionContext(level, DropConditionType.BLOCK, tile.m_58900_().m_60734_().getRegistryName(), player);
        context.addTags(((TemplateTagContainer)tile).getTemplateTags());
        return context;
    }

    public static DropConditionContext makeEntityContext(int level, LivingEntity entity) {
        return DropConditionContextFactory.makeEntityContext(level, entity, null);
    }

    public static DropConditionContext makeEntityContext(int level, LivingEntity entity, @Nullable ServerPlayer player) {
        DropEntityConditionContext context = new DropEntityConditionContext(level, entity.m_6095_().getRegistryName(), entity, player);
        CompoundTag forgeData = entity.getPersistentData();
        if (forgeData.m_128425_("template_tags", 9)) {
            ListTag tagList = forgeData.m_128437_("template_tags", 8);
            for (Tag tag : tagList) {
                context.addTag(tag.m_7916_());
            }
        }
        return context;
    }

    public static DropConditionContext makeRewardCrate(int level, Block block) {
        return DropConditionContextFactory.makeRewardCrate(level, block, null);
    }

    public static DropConditionContext makeRewardCrate(int level, Block block, @Nullable ServerPlayer player) {
        return new DropConditionContext(level, DropConditionType.REWARD_CRATE, block.getRegistryName(), player);
    }
}

