/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.reward;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import iskallia.vault.antique.reward.AntiqueRewardTypeRegistry;
import iskallia.vault.core.random.RandomSource;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AntiqueReward {
    private ResourceLocation providerId;

    public abstract List<ItemStack> generateReward(RandomSource var1, ServerPlayer var2, int var3);

    public abstract void deserialize(JsonDeserializationContext var1, JsonObject var2);

    public abstract JsonObject serialize(JsonSerializationContext var1);

    public final <T> T cast() {
        return (T)this;
    }

    public static class Serializer
    implements JsonDeserializer<AntiqueReward>,
    JsonSerializer<AntiqueReward> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public AntiqueReward deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            String typeStr = GsonHelper.m_13906_((JsonObject)object, (String)"type");
            ResourceLocation typeId = ResourceLocation.m_135820_((String)typeStr);
            if (typeId == null) {
                throw new JsonSyntaxException("Unknown reward type: " + typeStr);
            }
            Provider provider = (Provider)AntiqueRewardTypeRegistry.getRegistry().getValue(typeId);
            if (provider == null) {
                throw new JsonSyntaxException("Unknown reward type: " + typeStr);
            }
            AntiqueReward reward = provider.provideReward();
            reward.deserialize(context, object);
            return reward;
        }

        public JsonElement serialize(AntiqueReward src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = src.serialize(context);
            object.addProperty("type", src.providerId.toString());
            return object;
        }
    }

    public static abstract class Provider
    extends ForgeRegistryEntry<Provider> {
        public Provider(ResourceLocation id) {
            this.setRegistryName(id);
        }

        public final AntiqueReward provideReward() {
            AntiqueReward condition = this.makeReward();
            condition.providerId = this.getRegistryName();
            return condition;
        }

        protected abstract AntiqueReward makeReward();

        public static Provider make(ResourceLocation id, final Supplier<AntiqueReward> newInst) {
            return new Provider(id){

                @Override
                public AntiqueReward makeReward() {
                    return (AntiqueReward)newInst.get();
                }
            };
        }
    }
}

