/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.reward;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import iskallia.vault.antique.reward.AntiqueReward;
import iskallia.vault.core.random.RandomSource;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class AntiqueRewardCombined
extends AntiqueReward {
    private final List<AntiqueReward> rewards = new ArrayList<AntiqueReward>();

    @Override
    public List<ItemStack> generateReward(RandomSource random, ServerPlayer player, int level) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (AntiqueReward reward : this.rewards) {
            stacks.addAll(reward.generateReward(random, player, level));
        }
        return stacks;
    }

    @Override
    public void deserialize(JsonDeserializationContext ctx, JsonObject json) {
        JsonArray rewards = json.getAsJsonArray("rewards");
        for (int i = 0; i < rewards.size(); ++i) {
            this.rewards.add((AntiqueReward)ctx.deserialize(rewards.get(i), AntiqueReward.class));
        }
    }

    @Override
    public JsonObject serialize(JsonSerializationContext ctx) {
        JsonObject object = new JsonObject();
        JsonArray rewards = new JsonArray();
        for (AntiqueReward reward : this.rewards) {
            rewards.add(ctx.serialize((Object)reward));
        }
        object.add("rewards", (JsonElement)rewards);
        return object;
    }
}

