/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.reward;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import iskallia.vault.antique.reward.AntiqueReward;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.util.LootInitialization;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class AntiqueRewardItemList
extends AntiqueReward {
    private WeightedList<ItemStack> results = new WeightedList();
    private Range count = new Range(1, 1);

    public void setCount(Range count) {
        this.count = count;
    }

    public void addResult(ItemStack stack, double weight) {
        this.results.add(stack, weight);
    }

    @Override
    public List<ItemStack> generateReward(RandomSource random, ServerPlayer player, int level) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        this.results.getRandom(random).ifPresent(stack -> {
            ItemStack result = stack.m_41777_();
            result = LootInitialization.initializeVaultLoot(result, level, random);
            result.m_41764_(this.count.get(random));
            out.add(result);
        });
        return out;
    }

    @Override
    public void deserialize(JsonDeserializationContext ctx, JsonObject json) {
        this.results = new WeightedList();
        JsonArray results = json.getAsJsonArray("results");
        for (int i = 0; i < results.size(); ++i) {
            JsonObject result = results.get(i).getAsJsonObject();
            ItemStack stack = (ItemStack)ctx.deserialize(result.get("item"), ItemStack.class);
            double weight = result.get("weight").getAsDouble();
            this.results.add(stack, weight);
        }
        this.count = Range.deserialize(json.getAsJsonObject("count"));
    }

    @Override
    public JsonObject serialize(JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonArray results = new JsonArray();
        this.results.forEach((stack, weight) -> {
            JsonObject result = new JsonObject();
            result.add("item", ctx.serialize(stack));
            result.addProperty("weight", (Number)weight);
            results.add((JsonElement)result);
        });
        json.add("results", (JsonElement)results);
        json.add("count", (JsonElement)this.count.serialize());
        return json;
    }

    public static class Range {
        private final int min;
        private final int max;

        public Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int get(RandomSource random) {
            return random.nextInt(this.max - this.min + 1) + this.min;
        }

        public static Range deserialize(JsonObject json) {
            return new Range(json.get("min").getAsInt(), json.get("max").getAsInt());
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("min", (Number)this.min);
            json.addProperty("max", (Number)this.max);
            return json;
        }
    }
}

