/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.antique.reward;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import iskallia.vault.antique.reward.AntiqueRewardItemList;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.VaultGearLegendaryHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.MiscUtils;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AntiqueRewardSpecificGear
extends AntiqueRewardItemList {
    @Nullable
    private String guaranteedModifier;
    @Nullable
    private ModifierReferenceType referenceType;
    @Nullable
    private ModifierOperation operation;

    public void setGuaranteedModifier(@Nullable String guaranteedModifier) {
        this.guaranteedModifier = guaranteedModifier;
    }

    public void setReferenceType(@Nullable ModifierReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void setOperation(@Nullable ModifierOperation operation) {
        this.operation = operation;
    }

    @Override
    public List<ItemStack> generateReward(RandomSource random, ServerPlayer player, int level) {
        return super.generateReward(random, player, level).stream().map(stack -> {
            if (this.guaranteedModifier != null && this.referenceType != null ? !this.applyModifications((ItemStack)stack, random, player, level) : this.operation == ModifierOperation.MAKE_LEGENDARY && !this.forceLegendaryModifier((ItemStack)stack, player, random)) {
                return ItemStack.f_41583_;
            }
            return stack;
        }).filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
    }

    private boolean forceLegendaryModifier(ItemStack stack, ServerPlayer player, RandomSource random) {
        GearDataCache cache;
        Item item = stack.m_41720_();
        if (!(item instanceof VaultGearItem)) {
            return false;
        }
        VaultGearItem vgi = (VaultGearItem)item;
        Random javaRand = new Random(random.nextLong());
        VaultGearData data = VaultGearData.read(stack);
        if (data.getState() == VaultGearState.UNIDENTIFIED) {
            vgi.instantIdentify((Player)player, stack);
        }
        if ((cache = GearDataCache.of(stack)).hasModifierOfCategory(VaultGearModifier.AffixCategory.LEGENDARY)) {
            return true;
        }
        if (VaultGearLegendaryHelper.generateImprovedModifier(stack.m_41777_(), 2, javaRand, List.of(VaultGearModifier.AffixCategory.LEGENDARY))) {
            return VaultGearLegendaryHelper.generateImprovedModifier(stack, 2, javaRand, List.of(VaultGearModifier.AffixCategory.LEGENDARY));
        }
        return false;
    }

    private boolean applyModifications(ItemStack stack, RandomSource random, ServerPlayer player, int level) {
        VaultGearModifier<?> newModifier;
        VaultGearAttribute<Integer> affixAttribute;
        Tuple<VaultGearModifier.AffixType, VaultGearModifier<?>> generated;
        if (this.referenceType == null || this.guaranteedModifier == null) {
            return false;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof VaultGearItem)) {
            return false;
        }
        VaultGearItem vgi = (VaultGearItem)item;
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            return false;
        }
        vgi.instantIdentify((Player)player, stack);
        switch (this.referenceType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TAG: {
                Tuple<VaultGearModifier.AffixType, VaultGearModifier<?>> tuple = this.getByTag(cfg, level, random);
                break;
            }
            case GROUP: {
                Tuple<VaultGearModifier.AffixType, VaultGearModifier<?>> tuple = this.getByGroup(cfg, level, random);
                break;
            }
            case IDENTIFIER: {
                Tuple<VaultGearModifier.AffixType, VaultGearModifier<?>> tuple = generated = this.getByIdentifier(cfg, level, random);
            }
        }
        if (generated == null) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        VaultGearModifier.AffixType affixType = (VaultGearModifier.AffixType)((Object)generated.m_14418_());
        VaultGearModifier<?> modifier = (VaultGearModifier<?>)generated.m_14419_();
        if (modifier.getModifierIdentifier() != null) {
            data.getModifiersFulfilling(mod -> mod.getModifierIdentifier().equals((Object)modifier.getModifierIdentifier())).forEach(data::removeModifier);
        }
        if (modifier.getModifierGroup() != null) {
            data.getModifiersFulfilling(mod -> mod.getModifierGroup().equals(modifier.getModifierGroup())).forEach(data::removeModifier);
        }
        switch (affixType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PREFIX: {
                VaultGearAttribute<Integer> vaultGearAttribute = ModGearAttributes.PREFIXES;
                break;
            }
            case SUFFIX: {
                VaultGearAttribute<Integer> vaultGearAttribute = ModGearAttributes.SUFFIXES;
                break;
            }
            case IMPLICIT: {
                VaultGearAttribute<Integer> vaultGearAttribute = affixAttribute = null;
            }
        }
        if (affixAttribute != null) {
            int affixSlots;
            int attempts = affixSlots = data.getFirstValue(affixAttribute).orElse(0).intValue();
            int affixes = data.getModifiers(affixType).size();
            while (affixes >= affixSlots && attempts > 0) {
                List<VaultGearModifier> removableModifiers = data.getModifiers(affixType).stream().filter(VaultGearModifier::canBeModified).toList();
                if (removableModifiers.isEmpty()) {
                    return false;
                }
                VaultGearModifier randomMod = MiscUtils.getRandomEntry(removableModifiers);
                if (randomMod == null) {
                    return false;
                }
                if (!data.removeModifier(randomMod)) {
                    --attempts;
                }
                affixes = data.getModifiers(affixType).size();
            }
            if (attempts <= 0) {
                return false;
            }
        }
        VaultGearModifier<?> modifierToAdd = modifier;
        if (this.operation == ModifierOperation.MAKE_LEGENDARY && (newModifier = cfg.maxAndIncreaseTier(affixType, modifier, level, 2, new Random(random.nextLong()))) != null) {
            newModifier.addCategory(VaultGearModifier.AffixCategory.LEGENDARY);
            modifierToAdd = newModifier;
        }
        if (affixType == VaultGearModifier.AffixType.IMPLICIT) {
            data.addModifier(affixType, modifierToAdd);
        } else {
            data.addModifierFirst(affixType, modifierToAdd);
        }
        data.write(stack);
        return true;
    }

    private Tuple<VaultGearModifier.AffixType, VaultGearModifier<?>> getByTag(VaultGearTierConfig cfg, int level, RandomSource random) {
        WeightedList outcomes = new WeightedList();
        cfg.getGenericGroupsWithModifierTag(this.guaranteedModifier).forEach(tpl -> {
            VaultGearModifier.AffixType affix = ((VaultGearTierConfig.ModifierAffixTagGroup)((Object)((Object)tpl.m_14418_()))).getTargetAffixType();
            if (affix == null) {
                return;
            }
            VaultGearTierConfig.ModifierTierGroup group = (VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_();
            if (this.operation == ModifierOperation.HIGHEST_TIER) {
                VaultGearTierConfig.ModifierTier<?> foundTier = group.getHighestForLevel(level);
                if (foundTier != null) {
                    outcomes.add(new Tuple((Object)affix, new VaultGearTierConfig.ModifierOutcome(foundTier, group)), foundTier.getWeight());
                }
            } else {
                group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new Tuple((Object)affix, new VaultGearTierConfig.ModifierOutcome(tier, group)), tier.getWeight()));
            }
        });
        Tuple resultTpl = outcomes.getRandom(random).orElse(null);
        if (resultTpl == null) {
            return null;
        }
        return new Tuple((Object)((VaultGearModifier.AffixType)((Object)resultTpl.m_14418_())), ((VaultGearTierConfig.ModifierOutcome)resultTpl.m_14419_()).makeModifier(new Random(random.nextLong())));
    }

    private Tuple<VaultGearModifier.AffixType, VaultGearModifier<?>> getByGroup(VaultGearTierConfig cfg, int level, RandomSource random) {
        WeightedList outcomes = new WeightedList();
        cfg.getGenericGroupsWithModifierGroup(this.guaranteedModifier).forEach(tpl -> {
            VaultGearModifier.AffixType affix = ((VaultGearTierConfig.ModifierAffixTagGroup)((Object)((Object)tpl.m_14418_()))).getTargetAffixType();
            if (affix == null) {
                return;
            }
            VaultGearTierConfig.ModifierTierGroup group = (VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_();
            if (this.operation == ModifierOperation.HIGHEST_TIER) {
                VaultGearTierConfig.ModifierTier<?> foundTier = group.getHighestForLevel(level);
                if (foundTier != null) {
                    outcomes.add(new Tuple((Object)affix, new VaultGearTierConfig.ModifierOutcome(foundTier, group)), foundTier.getWeight());
                }
            } else {
                group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new Tuple((Object)affix, new VaultGearTierConfig.ModifierOutcome(tier, group)), tier.getWeight()));
            }
        });
        Tuple resultTpl = outcomes.getRandom(random).orElse(null);
        if (resultTpl == null) {
            return null;
        }
        return new Tuple((Object)((VaultGearModifier.AffixType)((Object)resultTpl.m_14418_())), ((VaultGearTierConfig.ModifierOutcome)resultTpl.m_14419_()).makeModifier(new Random(random.nextLong())));
    }

    private Tuple<VaultGearModifier.AffixType, VaultGearModifier<?>> getByIdentifier(VaultGearTierConfig cfg, int level, RandomSource random) {
        ResourceLocation key = ResourceLocation.m_135820_((String)this.guaranteedModifier);
        if (key == null) {
            return null;
        }
        VaultGearTierConfig.ModifierTierGroup group = cfg.getTierGroup(key);
        if (group == null) {
            return null;
        }
        VaultGearTierConfig.ModifierAffixTagGroup affixGroup = group.getTargetAffixTagGroup();
        if (affixGroup == null) {
            return null;
        }
        VaultGearModifier.AffixType affixType = affixGroup.getTargetAffixType();
        if (affixType == null) {
            return null;
        }
        WeightedList outcomes = new WeightedList();
        if (this.operation == ModifierOperation.HIGHEST_TIER) {
            VaultGearTierConfig.ModifierTier<?> foundTier = group.getHighestForLevel(level);
            if (foundTier != null) {
                outcomes.add(new VaultGearTierConfig.ModifierOutcome(foundTier, group), foundTier.getWeight());
            }
        } else {
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new VaultGearTierConfig.ModifierOutcome(tier, group), tier.getWeight()));
        }
        VaultGearModifier generatedModifier = outcomes.getRandom().map(modifierOutcome -> modifierOutcome.makeModifier(new Random(random.nextLong()))).orElse(null);
        if (generatedModifier == null) {
            return null;
        }
        return new Tuple((Object)affixType, (Object)generatedModifier);
    }

    @Override
    public void deserialize(JsonDeserializationContext ctx, JsonObject json) {
        super.deserialize(ctx, json);
        if (json.has("guaranteedModifier") && json.has("referenceType")) {
            this.guaranteedModifier = json.get("guaranteedModifier").getAsString();
            this.referenceType = ModifierReferenceType.valueOf(json.get("referenceType").getAsString());
        }
        if (json.has("operation")) {
            this.operation = ModifierOperation.valueOf(json.get("operation").getAsString());
        }
    }

    @Override
    public JsonObject serialize(JsonSerializationContext ctx) {
        JsonObject json = super.serialize(ctx);
        if (this.guaranteedModifier != null && this.referenceType != null) {
            json.addProperty("guaranteedModifier", this.guaranteedModifier);
            json.addProperty("referenceType", this.referenceType.name());
        }
        if (this.operation != null) {
            json.addProperty("operation", this.operation.name());
        }
        return json;
    }

    public static enum ModifierReferenceType {
        TAG,
        GROUP,
        IDENTIFIER;

    }

    public static enum ModifierOperation {
        HIGHEST_TIER,
        MAKE_LEGENDARY;

    }
}

