/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.backup;

import iskallia.vault.integration.IntegrationCurios;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.ModList;

public class BackupManager {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd--HH-mm-ss");
    private static final Pattern DATE_FORMAT_EXTRACTOR = Pattern.compile("^(.*)\\.dat$");

    private BackupManager() {
    }

    public static boolean createPlayerInventorySnapshot(ServerPlayer playerEntity) {
        MinecraftServer srv = playerEntity.m_20194_();
        if (srv == null) {
            return false;
        }
        ListTag list = new ListTag();
        for (int index = 0; index < playerEntity.m_150109_().m_6643_(); ++index) {
            ItemStack stack = playerEntity.m_150109_().m_8020_(index);
            if (stack.m_41619_()) continue;
            list.add((Object)stack.serializeNBT());
        }
        if (ModList.get().isLoaded("curios")) {
            list.addAll(IntegrationCurios.getSerializedCuriosItemStacks((Player)playerEntity));
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("data", (Tag)list);
        File datFile = BackupManager.getStoredFile(srv, playerEntity.m_142081_(), DATE_FORMAT.format(LocalDateTime.now()));
        try {
            NbtIo.m_128955_((CompoundTag)tag, (File)datFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Optional<List<ItemStack>> getStoredItemStacks(MinecraftServer server, UUID playerUUID, String timestampRef) {
        CompoundTag tag;
        File storedFile = BackupManager.getStoredFile(server, playerUUID, timestampRef);
        if (!storedFile.exists()) {
            return Optional.empty();
        }
        try {
            tag = NbtIo.m_128953_((File)storedFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        ListTag data = tag.m_128437_("data", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < data.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)data.m_128728_(i));
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        return Optional.of(stacks);
    }

    public static List<String> getMostRecentBackupFileTimestamps(MinecraftServer server, UUID playerUUID) {
        return BackupManager.getBackupFileTimestamps(server, playerUUID, 5);
    }

    private static List<String> getBackupFileTimestamps(MinecraftServer server, UUID playerUUID, int count) {
        File dir = BackupManager.getStorageDir(server, playerUUID);
        File[] files = dir.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        Comparator<Tuple> tplTimeComparator = Comparator.comparing(Tuple::m_14419_);
        tplTimeComparator = tplTimeComparator.reversed();
        long limit = count < 0 ? Long.MAX_VALUE : (long)count;
        return Arrays.asList(files).stream().map(file -> {
            LocalDateTime dateTime;
            Matcher match = DATE_FORMAT_EXTRACTOR.matcher(file.getName());
            if (!match.find()) {
                return null;
            }
            String dateGroup = match.group(1);
            try {
                dateTime = LocalDateTime.parse(dateGroup, DATE_FORMAT);
            }
            catch (DateTimeParseException exc) {
                return null;
            }
            return new Tuple(file, (Object)dateTime);
        }).filter(Objects::nonNull).sorted(tplTimeComparator).limit(limit).map(tpl -> DATE_FORMAT.format((TemporalAccessor)tpl.m_14419_())).collect(Collectors.toList());
    }

    private static File getStoredFile(MinecraftServer srv, UUID playerUUID, String timestamp) {
        return new File(BackupManager.getStorageDir(srv, playerUUID), timestamp + ".dat");
    }

    private static File getStorageDir(MinecraftServer server, UUID playerUUID) {
        File dir = server.m_129843_(LevelResource.f_78182_).resolve("vault_inventory_backup").resolve(playerUUID.toString()).toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

