/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.AlchemyArchiveTileEntity;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.VoxelUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AlchemyArchiveBlock
extends Block
implements EntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    public static final VoxelShape SHAPE2 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);

    public AlchemyArchiveBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(-1.0f, 3600000.0f).m_60993_().m_60955_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return VoxelUtils.combineAll(BooleanOp.f_82695_, SHAPE, SHAPE2);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return BlockHelper.getTicker(type, ModBlocks.ALCHEMY_ARCHIVE_TILE_ENTITY, AlchemyArchiveTileEntity::clientBookTick);
        }
        return null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.ALCHEMY_ARCHIVE_TILE_ENTITY.m_155264_(pos, state);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, InteractionHand hand, BlockHitResult hit) {
        AlchemyArchiveTileEntity archive;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!VaultUtils.isVaultLevel(level)) {
            return InteractionResult.FAIL;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof AlchemyArchiveTileEntity) || !(archive = (AlchemyArchiveTileEntity)tile).canBeUsed(player)) {
            return InteractionResult.FAIL;
        }
        archive.use(sPlayer);
        return InteractionResult.SUCCESS;
    }
}

