/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.AngelBlockTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.DimensionPos;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AngelBlock
extends BaseEntityBlock
implements EntityBlock {
    protected static final int ANGEL_BLOCK_RANGE = 64;
    protected final Set<DimensionPos> angelBlocks = new HashSet<DimensionPos>();
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public AngelBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(1.5f, 6.0f).m_60955_().m_60953_(state -> 15));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void addPlayerAngelBlock(ResourceKey<Level> dimension, BlockPos pos) {
        this.angelBlocks.add(new DimensionPos(dimension, pos));
    }

    public boolean isPlayerInRange(Player player) {
        for (DimensionPos dimensionPos : this.angelBlocks) {
            if (!dimensionPos.isInRange((ResourceKey<Level>)player.m_183503_().m_46472_(), player.m_142538_(), 64)) continue;
            return true;
        }
        return false;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new AngelBlockTileEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.m_5776_() ? BlockHelper.getTicker(pBlockEntityType, ModBlocks.ANGEL_BLOCK_TILE_ENTITY, AngelBlockTileEntity::tick) : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(level, pos, pState, pPlacer, pStack);
        ModBlocks.ANGEL_BLOCK.addPlayerAngelBlock((ResourceKey<Level>)level.m_46472_(), pos);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_60734_() != pNewState.m_60734_()) {
            pLevel.m_141902_(pPos, ModBlocks.ANGEL_BLOCK_TILE_ENTITY).ifPresent(blockEntity -> this.angelBlocks.remove(new DimensionPos((ResourceKey<Level>)pLevel.m_46472_(), pPos)));
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }
}

